/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.LevelExchange;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCClass;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class ExchangelevelToken
extends AbstractTokenWithSeparator<PCClass>
implements CDOMPrimaryToken<PCClass> {
    @Override
    public String getTokenName() {
        return "EXCHANGELEVEL";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, PCClass pcc, String value) {
        int minrem;
        int maxdl;
        int mindl;
        StringTokenizer tok = new StringTokenizer(value, "|");
        if (tok.countTokens() != 4) {
            return new ParseResult.Fail(this.getTokenName() + " must have 4 | delimited arguments : " + value, context);
        }
        String classString = tok.nextToken();
        CDOMSingleRef<PCClass> cl = context.getReferenceContext().getCDOMReference(PCClass.class, classString);
        String mindlString = tok.nextToken();
        try {
            mindl = Integer.parseInt(mindlString);
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " expected an integer: " + mindlString, context);
        }
        String maxdlString = tok.nextToken();
        try {
            maxdl = Integer.parseInt(maxdlString);
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " expected an integer: " + maxdlString, context);
        }
        String minremString = tok.nextToken();
        try {
            minrem = Integer.parseInt(minremString);
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " expected an integer: " + minremString, context);
        }
        try {
            LevelExchange le = new LevelExchange(cl, mindl, maxdl, minrem);
            context.getObjectContext().put((CDOMObject)pcc, ObjectKey.EXCHANGE_LEVEL, le);
            return ParseResult.SUCCESS;
        }
        catch (IllegalArgumentException e) {
            ComplexParseResult pr = new ComplexParseResult();
            pr.addErrorMessage("Error in " + this.getTokenName() + " " + e.getMessage());
            pr.addErrorMessage("  Token contents: " + value);
            return pr;
        }
    }

    @Override
    public String[] unparse(LoadContext context, PCClass pcc) {
        LevelExchange le = context.getObjectContext().getObject(pcc, ObjectKey.EXCHANGE_LEVEL);
        if (le == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(le.getExchangeClass().getLSTformat(false)).append("|");
        sb.append(le.getMinDonatingLevel()).append("|");
        sb.append(le.getMaxDonatedLevels()).append("|");
        sb.append(le.getDonatingLowerLevelBound());
        return new String[]{sb.toString()};
    }

    @Override
    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

