/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.StringTokenizer;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.AbstractExportToken;

public class ExpToken
extends AbstractExportToken {
    public String getTokenName() {
        return "EXP";
    }

    public String getToken(String tokenSource, CharacterDisplay display, ExportHandler eh) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        if (aTok.hasMoreTokens()) {
            String token = aTok.nextToken();
            if ("CURRENT".equals(token)) {
                retString = Integer.toString(display.getXP());
            } else if ("NEXT".equals(token)) {
                retString = Integer.toString(display.minXPForNextECL());
            } else if ("FACTOR".equals(token)) {
                retString = ExpToken.getFactorToken(display);
            } else if ("PENALTY".equals(token)) {
                retString = ExpToken.getPenaltyToken(display);
            }
        }
        return retString;
    }

    public static String getFactorToken(CharacterDisplay display) {
        StringBuilder xpFactor = new StringBuilder(5);
        xpFactor.append((int)(display.multiclassXPMultiplier() * 100.0));
        xpFactor.append('%');
        return xpFactor.toString();
    }

    public static String getPenaltyToken(CharacterDisplay display) {
        StringBuilder xpFactor = new StringBuilder(5);
        xpFactor.append(100 - (int)(display.multiclassXPMultiplier() * 100.0));
        xpFactor.append('%');
        return xpFactor.toString();
    }
}

