#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <time.h>

#include <FL/Fl.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Output.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Check_Button.H>
#include <FL/Fl_Multiline_Output.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Text_Buffer.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Choice.H>

#ifdef __CYGWIN__
#include <sys/cygwin.h>
#endif

#define TAM_SIZE 1024

#define VERSION "0.3"

class MainWindow {
   public:
     MainWindow();
     ~MainWindow();
   
   	 pid_t child_pid;
   
     int pipefd[2];	    
   
   	 Fl_Window *window;
     Fl_Menu_Bar *menu;
   
     Fl_Text_Display *output_window;
     Fl_Text_Buffer  *output_buffer;
     
     Fl_Input            *dumpfile_input;
     Fl_Input            *wordfile_input;
     Fl_Input            *mac_input;     
     Fl_Input            *firstkey_input;
     Fl_Input            *lastkey_input;
     Fl_Input            *server_data_input;
   
     Fl_Choice           *mode_input;
     Fl_Choice           *num_net_input;
	 Fl_Choice           *generator_mode_input;
	 Fl_Choice           *blocks_to_decrypt_input;
   
     Fl_Button			 *start;
     Fl_Button			 *stop;
   
     Fl_Check_Button     *wordfile_button;
     Fl_Check_Button     *mac_button;
     Fl_Check_Button     *mode_button;
     Fl_Check_Button     *client_button;
     Fl_Check_Button     *num_net_button;
	 Fl_Check_Button     *generator_mode_button;
	 Fl_Check_Button     *blocks_to_decrypt_button;	 
};

class LogFile{
	public:
		char directory[75];
		LogFile();
		~LogFile();
};

int show_about = 0;
int size = 0;

MainWindow::MainWindow(){
	
	window = new Fl_Window(350,460);
    menu = new Fl_Menu_Bar(0, 0, 350, 20);
	
	dumpfile_input = new Fl_Input(10, 30, 330, 20, NULL);
	dumpfile_input->value("Dump File");		
	
	wordfile_button = new Fl_Check_Button(10, 60, 20, 20, NULL);
	wordfile_button->type(FL_TOGGLE_BUTTON);
	wordfile_input = new Fl_Input(30, 60, 310, 20, NULL);
	wordfile_input->value("Word File");
	
	mac_button = new Fl_Check_Button(10, 90, 20, 20, NULL);
	mac_button->type(FL_TOGGLE_BUTTON);
	mac_input = new Fl_Input(30, 90, 190, 20, NULL);
	mac_input->value("Mac Filter");	
	
	mode_button = new Fl_Check_Button(230, 90, 20, 20, NULL);
	mode_button->type(FL_TOGGLE_BUTTON);
	mode_input = new Fl_Choice(250, 90, 90, 20, NULL);
	
	Fl_Menu_Item mode_menu[] = {
	    { "Mode", 0, 0, 0, 0 },
		{ "nall", 0, 0, 0, 0 },
		{ "n128", 0, 0, 0, 0 },
		{ "n64", 0, 0, 0, 0 },
		{ "128", 0, 0, 0, 0 },
		{ "64", 0, 0, 0, 0 },
	    { 0 },	
  	};
	
	mode_input->copy(mode_menu);
	
	client_button = new Fl_Check_Button(10, 120, 20, 20, NULL);
	client_button->type(FL_TOGGLE_BUTTON);
	server_data_input = new Fl_Input(30, 120, 190, 20, NULL);
	server_data_input->value("Client Mode");
	
	blocks_to_decrypt_button = new Fl_Check_Button(230, 120, 20, 20);
	blocks_to_decrypt_input  = new Fl_Choice(250, 120, 90, 20);
	
	Fl_Menu_Item blocks_to_decrypt_menu[] = {
	    { "Num Blocks", 0, 0, 0, 0 },
		{ "0", 0, 0, 0, 0 },
		{ "1", 0, 0, 0, 0 },
		{ "2", 0, 0, 0, 0 },
		{ "3", 0, 0, 0, 0 },
		{ "4", 0, 0, 0, 0 },
		{ "5", 0, 0, 0, 0 },
		{ "6", 0, 0, 0, 0 },
		{ "7", 0, 0, 0, 0 },
		{ "8", 0, 0, 0, 0 },
		{ "9", 0, 0, 0, 0 },
	    { 0 },	
  	};
	
	blocks_to_decrypt_input->copy(blocks_to_decrypt_menu);
	
	generator_mode_button = new Fl_Check_Button(10, 150, 20, 20, NULL);
	generator_mode_input  = new Fl_Choice(30, 150, 190, 20, NULL);
	
	Fl_Menu_Item generator_mode_menu[] = {
	    { "Generator mode", 0, 0, 0, 0 },
		{ "all", 0, 0, 0, 0 },
		{ "alpha", 0, 0, 0, 0 },
		{ "alphanumeric", 0, 0, 0, 0 },
		{ "numeric", 0, 0, 0, 0 },
		{ "random", 0, 0, 0, 0 },
		{ "printable", 0, 0, 0, 0 },
	    { 0 },	
  	};
	
	generator_mode_input->copy(generator_mode_menu);
	
    num_net_button = new Fl_Check_Button(230, 150, 20, 20, NULL);
	num_net_button->type(FL_TOGGLE_BUTTON);
	num_net_input = new Fl_Choice(250, 150, 90, 20, NULL);
	
	Fl_Menu_Item num_net_menu[] = {
	    { "Num Net", 0, 0, 0, 0 },
		{ "1", 0, 0, 0, 0 },
		{ "2", 0, 0, 0, 0 },
		{ "3", 0, 0, 0, 0 },
		{ "4", 0, 0, 0, 0 },
		{ "5", 0, 0, 0, 0 },
		{ "6", 0, 0, 0, 0 },
		{ "7", 0, 0, 0, 0 },
		{ "8", 0, 0, 0, 0 },
		{ "9", 0, 0, 0, 0 },
		{ "10", 0, 0, 0, 0 },
	    { 0 },	
  	};
	
	num_net_input->copy(num_net_menu);
	
	firstkey_input = new Fl_Input(10, 180, 150, 20, NULL);
	firstkey_input->value("First Key");	
	
	lastkey_input = new Fl_Input(175, 180, 165, 20, NULL);
	lastkey_input->value("Last Key");
	
	output_window = new Fl_Text_Display(10, 210, 330, 200, NULL);
	output_buffer = new Fl_Text_Buffer(10);
	output_window->buffer(output_buffer);
	output_window->hide_cursor();	
	output_buffer->append("- WepDecrypt Gui -\n");
		
	start = new Fl_Button(70, 420, 80, 30, "START");
	start->shortcut(FL_Enter);
	stop = new Fl_Button(195, 420, 80, 30, "STOP");
	stop->shortcut('q');
	
	child_pid = 0;
	
	Fl::focus(start);
	
}

MainWindow::~MainWindow(){
}

LogFile::LogFile(){
	directory[0] = '\0';
}

LogFile::~LogFile(){
}

void exit_cb(Fl_Widget * , void * );
void load_dumpfile_cb(Fl_Widget *, void * );
void load_wordfile_cb(Fl_Widget *, void * );
void fd_ready(int , void *);
void start_cb(Fl_Widget * , void * );
void stop_cb(Fl_Widget * , void * );

#ifndef __CYGWIN__
void about_cb(Fl_Widget *, void * );
void close_about_window_cb(Fl_Widget * v , void * );
#endif

void version_cb(Fl_Widget *, void * );
void help_cb(Fl_Widget *, void * );
void sigchld(int);
void set_log_options(LogFile *, MainWindow *);
void set_log_dir(Fl_Widget *, void *);
int manage_config_file(int , int *, char *, int *, char *, char *);


int main(int argc, char **argv) {
  MainWindow win;
  LogFile log;
	
  signal(SIGCHLD, sigchld);
	
  win.window->label("GWepDecrypt");
	
  Fl_Menu_Item menuitems[] = {
	    { "&File", 0, 0, 0, FL_SUBMENU },
		{ "Open &DumpFile", FL_CTRL + 'd', (Fl_Callback *)load_dumpfile_cb, (void *) &win, 0 },
		{ "Open &WordFile", FL_CTRL + 'w', (Fl_Callback *)load_wordfile_cb, (void *) &win, 0 },
		{ "Set &Log Dir", FL_CTRL + 'l', (Fl_Callback *)set_log_dir, (void *) &log, 0},
	    { "&Quit", FL_CTRL + 'q', (Fl_Callback *)exit_cb, (void *) &win, 0 },
	    { 0 },
		{ "&Help", 0, 0, 0, FL_SUBMENU },
#ifndef __CYGWIN__
		{ "&About", FL_CTRL + 'a', (Fl_Callback *)about_cb, 0, 0 },
#endif
		{ "&Help", FL_CTRL + 'h', (Fl_Callback *)help_cb, (void *) &win, 0 },
		{ "&Version", FL_CTRL + 'v', (Fl_Callback *)version_cb, (void *) &win, 0 },
		{ 0 },
      {0}
  };
  
  win.menu->copy(menuitems);
  win.window->end();
  
  set_log_options(&log, &win);  
  chdir(log.directory);  
  
  win.start->callback(start_cb, (void *) &win);
  win.stop->callback(stop_cb, (void *) &win);
  
  win.window->show(argc, argv);
  return Fl::run();
}

void exit_cb(Fl_Widget * , void * w){
	MainWindow * win = (MainWindow *) w;
	
	if (win->child_pid){
		kill(win->child_pid, SIGINT);
	}
	
	exit(0);
}

void load_dumpfile_cb(Fl_Widget *, void * v){	
	char * file_name;
#ifdef __CYGWIN__
	char win_file_name[100];
#endif
	MainWindow * win = (MainWindow *) v;
	
	file_name = fl_file_chooser("Choose a Dump File", NULL, NULL, 0);

#ifndef __CYGWIN__	
	if (file_name != NULL) win->dumpfile_input->value(file_name);
#else
	if (file_name != NULL){
		cygwin_conv_to_win32_path(file_name, win_file_name);
		win->dumpfile_input->value(win_file_name);
	}
#endif
	
}

void load_wordfile_cb(Fl_Widget *, void * v){	
	char * file_name;
#ifdef __CYGWIN__
	char win_file_name[100];
#endif

	MainWindow * win = (MainWindow *) v;
	
	file_name = fl_file_chooser("Choose a Word File", NULL, NULL, 0);
	
	if (file_name != NULL){
		win->wordfile_button->set();

#ifndef __CYGWIN__
		win->wordfile_input->value(file_name);
#else
		cygwin_conv_to_win32_path(file_name, win_file_name);
		win->wordfile_input->value(win_file_name);
#endif

	}
}

void fd_ready(int fd, void *data) {
	int bytes, pos = 0, erase_last_line = 0, i;
	static int erase_first_line=0;
	char string[TAM_SIZE+1], * aux_string;
	MainWindow * win = (MainWindow *) data;
	
	bytes = read(fd, string, TAM_SIZE);
	string[bytes] = '\0';
	aux_string = string;
	
	if (!bytes){
		win->child_pid = size = 0;
		Fl::remove_fd(STDIN_FILENO);
		return;
	}
	
	if (erase_first_line){
		erase_first_line = 0;
		while(string[pos] != '\n' && string[pos] != '\0') pos++;

#ifndef __CYGWIN__
		if (size < 7) aux_string = &string[pos];
		else aux_string = &string[++pos];
#else
		if (size != 8) aux_string = &string[pos];
		else aux_string = &string[++pos];
#endif

	}
	
	if (size == 8){
		win->output_buffer->remove(0, win->output_buffer->length());
		size = 0;
		if (string[bytes-1] != '\n'){
			erase_last_line = 1;
			erase_first_line = 1;
		}
#ifdef __CYGWIN__
		win->output_buffer->append(aux_string);
		
		if (erase_last_line){
			win->output_buffer->findchar_backward(win->output_buffer->length(), '\n', &pos);
			win->output_buffer->remove(pos, win->output_buffer->length());
		}
		
		return;
#endif
	}
	
#ifndef __CYGWIN__
	if (bytes == TAM_SIZE && (size == 7 || size == 3)){
		if (string[bytes-1] != '\n'){
			erase_last_line = 1;
			erase_first_line = 1;
		}
	}
#else
	if (string[bytes-1] != '\n'){
		erase_last_line = 1;
		erase_first_line = 1;
	}
#endif
		
	win->output_buffer->append(aux_string);
	
	if (erase_last_line){
		win->output_buffer->findchar_backward(win->output_buffer->length(), '\n', &pos);
		win->output_buffer->remove(pos, win->output_buffer->length());
	}
	
	size++;
}
	

void start_cb(Fl_Widget * , void * v){
	int i=0,j=0, test_file;
	char * command[10], server_data[30];
	MainWindow * Win = (MainWindow *) v;
	
	if (Win->child_pid) return;
	
	for (i=0;i<10;i++){
		command[i] = new char[100];		
	}	
	
	i=0;
	
	Win->output_buffer->remove(0, Win->output_buffer->length());
	Win->output_buffer->append("- WepDecrypt Gui -\n");
	
	if (strncmp(Win->dumpfile_input->value(), "Dump File", 9) != 0){
		if (!Win->dumpfile_input->size()){
			Win->output_buffer->append("\nDump File can't be empty");			
			return;
		}
		//fprintf(stdout, "wepdecrypt -f %s ", Win->dumpfile_input->value());
		sprintf(command[i], "wepdecrypt"); i++;
		sprintf(command[i], "-f%s", Win->dumpfile_input->value());
		i++;
	}
	else{
		Win->output_buffer->append("\nYou must supply a Dump File");
		return;
	}
	
	if (Win->wordfile_button->value()){
		if (!Win->wordfile_input->size()){
			Win->output_buffer->append("\nWord File can't be empty");
			return;
		}
		if (!strncmp(Win->wordfile_input->value(), "Word File", 9)){
			Win->output_buffer->append("\nYou must supply a Word File");
			return;
		}			
		//fprintf(stdout, "-w %s ", Win->wordfile_input->value());
		sprintf(command[i], "-w%s", Win->wordfile_input->value());
		i++;
	}
	
	if (Win->mode_button->value()){
		if (!Win->mode_input->value()){
			Win->output_buffer->append("\nYou must supply a Crack Mode");
			return;
		}
		if (Win->mode_input->value() == 1 || Win->mode_input->value() == 2 || Win->mode_input->value() == 3){
			if (!Win->wordfile_button->value()){
				Win->output_buffer->append("\nYou must supply a Word File with nmodes");
				return;
			}
		}
		switch (Win->mode_input->value()){
			case 1:
				//fprintf(stdout, "-m nall ");
				sprintf(command[i], "-mnall");
				break;
			case 2:
				//fprintf(stdout, "-m n128 ");
				sprintf(command[i], "-mn128");
				break;
			case 3:
				//fprintf(stdout, "-m n64 ");
				sprintf(command[i], "-mn64");
				break;
			case 4:
				//fprintf(stdout, "-m 128 ");
				sprintf(command[i], "-m128");
				break;
			case 5:
				//fprintf(stdout, "-m 64 ");
				sprintf(command[i], "-m64");
				break;		
		}
		i++;
	}
	
	else if(!Win->client_button->value()){
		Win->output_buffer->append("\nYou must supply a Crack Mode");
		return;
	}
	
	if (Win->mac_button->value()){
		if (!Win->mac_input->size()){
			Win->output_buffer->append("\nMac can't be empty");
			return;
		}
		if (!strncmp(Win->mac_input->value(), "Mac Filter", 10)){
			Win->output_buffer->append("\nYou must supply a Mac");
			return;
		}
			
		//fprintf(stdout, "-b %s ", Win->mac_input->value());
		sprintf(command[i], "-b%s", Win->mac_input->value());
		i++;
	}
	
	if (Win->client_button->value()){
		if (!Win->server_data_input->size()){
			Win->output_buffer->append("\nServer data can't be empty");
			return;
		}
		if (!strncmp(Win->server_data_input->value(), "Client Mode", 11)){
			Win->output_buffer->append("\nYou must set server data");
			return;
		}
		strncpy(server_data, Win->server_data_input->value(), 30);
		
		// Check server data
		for (j=0;j<strlen(server_data);j++){
				if (server_data[j] == ':') break; 
		}
		if (j==strlen(server_data) || j==(strlen(server_data) - 1)){
			Win->output_buffer->append("\nBad client connection data");
			return ;
		}
		
		// Check server
		//fprintf(stdout, "-c %s", Win->server_data_input->value());
		sprintf(command[i], "-c%s", Win->server_data_input->value()); i++;
		sprintf(command[i], "-l0"); i++;
	}
	
	if (Win->blocks_to_decrypt_button->value()){
		if (!Win->client_button->value()){
			Win->output_buffer->append("\nYou have to set the client data");
			return;
		}
		if (!Win->blocks_to_decrypt_input->value()){
			Win->output_buffer->append("\nYou have to set the number of blocks to get\n from the server");
			return;
		}
		sprintf(command[i-1], "-l%i", Win->blocks_to_decrypt_input->value()-1);
		
	}
	
	if (Win->generator_mode_button->value()){
		if (!Win->generator_mode_input->value()){
			Win->output_buffer->append("\nYou have to set the generator mode");
			return;
		}
				
		switch(Win->generator_mode_input->value()){
			case 1:
				sprintf(command[i], "-dall");
				break;
			case 2:
				sprintf(command[i], "-dalpha");
				break;
			case 3:
				sprintf(command[i], "-dalphanumeric");
				break;
			case 4:
				sprintf(command[i], "-dnumeric");
				break;
			case 5:
				sprintf(command[i], "-drandom");
				break;
			case 6:
				sprintf(command[i], "-dprintable");
				break;
		}
		i++;
	}
		
	
	if (Win->num_net_button->value()){
		if (!Win->num_net_input->value()){
			Win->output_buffer->append("\nYou must set a Number network");
			return;
		}
		//fprintf(stdout, "-n %i ", Win->num_net_input->value());
		sprintf(command[i], "-n%i", Win->num_net_input->value());
		i++;
	}
	
	if (strncmp(Win->firstkey_input->value(), "First Key", 8) != 0){
		if (!Win->firstkey_input->size()){
			Win->output_buffer->append("\nFirst Key can't be empty");
			return;
		}
		//fprintf(stdout, "-i %s ", Win->firstkey_input->value());
		sprintf(command[i], "-i%s", Win->firstkey_input->value());
		i++;
	}
	
	if (strncmp(Win->lastkey_input->value(), "Last Key", 7) != 0){
		if (!Win->lastkey_input->size()){
			Win->output_buffer->append("\nLast Key can't be empty");
			return;
		}
		//fprintf(stdout, "-e %s ", Win->lastkey_input->value());
		sprintf(command[i], "-e%s", Win->lastkey_input->value());
		i++;
	}
	
	//fprintf(stdout, "\n");

#ifndef __CYGWIN__
	if ((test_file=open("/usr/bin/wepdecrypt", O_RDONLY)) == -1){
		Win->output_buffer->append("\nWepdecrypt executable can't be found\nplease install it at /usr/bin/");
		return;
	}
	else
		close(test_file);
#else
	if ((test_file=open("wepdecrypt.exe", O_RDONLY)) == -1){
		Win->output_buffer->append("\nWepdecrypt executable can't be found\nplease install it at the same directory\nas gwepdecrypt");
		return;
	}
	else
		close(test_file);
#endif
	
	command[i] = NULL;
	
	Fl::add_fd(STDIN_FILENO, fd_ready, (void*)Win);
	pipe(Win->pipefd);
	
	Win->output_buffer->append("\nProcessing ...\n");
	Win->child_pid = fork();
	
	if (Win->child_pid == -1){ // Error
		fprintf(stderr, "Error fork()\n");
		exit(0);
	}
	
	if (!Win->child_pid){
		dup2(Win->pipefd[1], STDOUT_FILENO);

		close(Win->pipefd[0]);
		close(Win->pipefd[1]);

#ifndef __CYGWIN__
		execv("/usr/bin/wepdecrypt", command);
#else
		execv("wepdecrypt.exe", command);
#endif

	}
	
	if (Win->child_pid){
		dup2(Win->pipefd[0], STDIN_FILENO);
		fcntl(STDIN_FILENO, F_SETFL, O_SYNC| O_NONBLOCK);
		close(Win->pipefd[0]);
		close(Win->pipefd[1]);		
	}
}

void stop_cb(Fl_Widget * , void * v){
	MainWindow * win = (MainWindow *) v;
	
	if (!win->child_pid) return;
	
	size = 0;
	kill(win->child_pid, SIGINT);
	win->child_pid=0;
}

#ifndef __CYGWIN__
void about_cb(Fl_Widget *, void * ){
	char ** argv;
	
	if (show_about == 0) {
		Fl_Window * about_window = new Fl_Window(205,95);
		Fl_Multiline_Output * about_box = new Fl_Multiline_Output(10, 10, 185, 55, NULL);
		Fl_Button * ok = new Fl_Button(85, 70, 40, 20, "OK");
		
		show_about = 1;
				
		about_box->value(" Gwepdecrypt version 0.3\n        Wepdecrypt's gui\n       by Fernando Tarin");	
	
		about_window->label("About");
		about_window->end();	
    
		
		about_window->show(1, argv);	
	
		Fl::focus(ok);
		ok->shortcut(FL_Enter);
		ok->callback(close_about_window_cb, (void *) about_window);
		Fl::run();
	}
}

void close_about_window_cb(Fl_Widget * v , void * w){
	Fl::delete_widget((Fl_Widget *) w);
	show_about = 0;
}
#endif

void version_cb(Fl_Widget *, void * v){
	int test_file;
	char version[25];
	
	MainWindow * Win = (MainWindow *) v;
	
	if (Win->child_pid) return;
		
	Win->output_buffer->remove(0, Win->output_buffer->length());
	Win->output_buffer->append("- WepDecrypt Gui -\n");
	
	sprintf(version, "\nGwepdecrypt version %s", VERSION);
	Win->output_buffer->append(version);
	Win->output_buffer->append("\nWepdecrypt graphic user interface\n\n");
	
#ifndef __CYGWIN__
	if ((test_file=open("/usr/bin/wepdecrypt", O_RDONLY)) == -1){
		Win->output_buffer->append("\nWepdecrypt executable can't be found\nplease install it at /usr/bin/");
		return;
	}
	else
		close(test_file);
#else
	if ((test_file=open("wepdecrypt.exe", O_RDONLY)) == -1){
		Win->output_buffer->append("\nWepdecrypt executable can't be found\nplease install it at the same directory\nas gwepdecrypt");
		return;
	}
	else
		close(test_file);
#endif
	
	Fl::add_fd(STDIN_FILENO, fd_ready, (void*)Win);	
	pipe(Win->pipefd);
	Win->child_pid = fork();
	
	if (Win->child_pid == -1){ // Error
		fprintf(stderr, "Error fork()\n");
		exit(0);
	}
	
	if (!Win->child_pid){
		dup2(Win->pipefd[1], STDOUT_FILENO);

		close(Win->pipefd[0]);
		close(Win->pipefd[1]);

#ifndef __CYGWIN__
		execl("/usr/bin/wepdecrypt", "wepdecrypt", "-v", NULL);
#else
		execl("wepdecrypt", "wepdecrypt", "-v", NULL);
#endif
		
	}
	
	if (Win->child_pid){
		dup2(Win->pipefd[0], STDIN_FILENO);
		fcntl(STDIN_FILENO, F_SETFL, O_SYNC| O_NONBLOCK);
		close(Win->pipefd[0]);
		close(Win->pipefd[1]);
		Win->child_pid = 0;
	}
}

void help_cb(Fl_Widget *, void * v){
	MainWindow * Win = (MainWindow *) v;
	
	if (Win->child_pid) return;
		
	Win->output_buffer->remove(0, Win->output_buffer->length());
	Win->output_buffer->append("- WepDecrypt Gui -\n");
	
	
	Win->output_buffer->append("\nGwepdecrypt options:\n");
	Win->output_buffer->append("--------------------------------------------------\n");
	Win->output_buffer->append("1. Dump file (filename):  network dumpfile to read\n");
	Win->output_buffer->append("2. Word file (filename):  wordlist to use as passwords\n");
	Win->output_buffer->append("3. Mac Filter (mac_addres): Filters the mac address from the dump file\n");
	Win->output_buffer->append("4. Mode: run wepdecrypt in diffente modes\n");
	Win->output_buffer->append("5. Client Mode (server:port): Host and port where server is running\n");
	Win->output_buffer->append("6. Number blocks: sets the number of blocks to get from the server\n");
	Win->output_buffer->append("7. Generator Mode: sets the mode for the key generator\n");
	Win->output_buffer->append("8. Number Network: network number to attack\n");
	Win->output_buffer->append("9. First key: specifies the first key\n");
	Win->output_buffer->append("10. Last key: specifies the final key\n");
	Win->output_buffer->append("--------------------------------------------------");
}

void sigchld(int sign){	
	waitpid(-1,NULL,WNOHANG);
}

void set_log_options(LogFile *log, MainWindow *win){
	char * home, config_file[75], message[100];
	FILE * fp;
	
#ifndef __CYGWIN__
	home = getenv("HOME");
	sprintf(config_file, "%s/.wepdecrypt", home);
#else
	sprintf(config_file, "wepdecrypt.conf", home);
#endif
	
	if ((fp = fopen(config_file, "r")) == NULL){

#ifndef __CYGWIN__
		strncpy(log->directory, "/tmp/", 6);
#else
		strncpy(log->directory, ".\\", 3);
#endif

		if ((fp = fopen(config_file,"w+")) == NULL){
			sprintf(message, "\nError in config file:\nCan't create config file");
			win->output_buffer->append(message);
			return;
		}
		fprintf(fp,"#Wepdecrypt configuration file\n");
		fprintf(fp,"#Server listening port\nPort=3617\n\n#Blocksize can be set up to 1099511627775\nBlocksize=4294967296\n\n#Full path to server logfile\nLogfile=/var/tmp/wepdecrypt_s.log\n\n#Verbosity levels: 1 - LOW 2 - MEDIUM 3 - HIGH\nVerbosity=2\n\n"
				   "#Full path to directory where gui generated logs will be saved\nGuidirlog=%s\n\n", log->directory);
		fclose(fp);
		return;
	}
	
	else{

		if (!manage_config_file(0, NULL, NULL, NULL, NULL, log->directory)){
			sprintf(message,"\nBad data in config file:\nPlease delete %s",config_file);
			win->output_buffer->append(message);

#ifndef __CYGWIN__
			strncpy(log->directory, "/tmp/", 6);
#else
			strncpy(log->directory, ".\\", 3);
#endif

			return;
		}
		
		if ((fp = fopen(config_file, "a")) == NULL){
			if (!strlen(log->directory)){

#ifndef __CYGWIN__
				strncpy(log->directory, "/tmp/", 6);
#else
				strncpy(log->directory, ".\\", 3);
#endif

			}
			sprintf(message,"\nError in config file:\nCan't append data to config file");
			win->output_buffer->append(message);
			return;
		}
		
		if (!strlen(log->directory)){

#ifndef __CYGWIN__
			strncpy(log->directory, "/tmp/", 6);
#else
			strncpy(log->directory, ".\\", 3);
#endif

			fprintf(fp, "#Full path to directory where gui generated logs will be saved\nGuidirlog=%s\n\n", log->directory);
		}
		
		fclose(fp);
		return;		
	}
}

void set_log_dir(Fl_Widget *, void * v){
	int verbosity, port;
	char * dir_name, * home, config_file[75];
	char block_size[15], log_file[55];
	FILE * fp;

#ifndef __CYGWIN__
	DIR * dir;
#endif

	LogFile * log = (LogFile *) v;
	
	
	dir_name = fl_dir_chooser("Choose a Directory", NULL, 0);
	if (dir_name != NULL){
		strncpy(log->directory, dir_name, strlen(dir_name)+1);

#ifndef __CYGWIN__
		if ((dir=opendir(log->directory)) == NULL){
			strncpy(log->directory, "/tmp/", 6);			
		}
#endif

		chdir(log->directory);

#ifndef __CYGWIN__		
		home = getenv("HOME");
		sprintf(config_file, "%s/.wepdecrypt", home);
#else
		sprintf(config_file, "wepdecrypt.conf");
#endif
		
		manage_config_file(0, &port, block_size, &verbosity, log_file, NULL);
		
		fp = fopen(config_file,"w+");
		fprintf(fp,"#Server listening port\nPort=%i\n\n#Blocksize can be set up to 1099511627775\nBlocksize=%s\n\n#Full path to server logfile\nLogfile=%s\n\n#Verbosity levels: 1 - LOW 2 - MEDIUM 3 - HIGH\nVerbosity=%i\n\n"
				   "#Full path to directory where gui generated logs will be saved\nGuidirlog=%s\n\n", port, block_size, log_file, verbosity, log->directory);
		fclose(fp);

#ifndef __CYGWIN__
		if (dir != NULL) closedir(dir);
#endif
		
	}
}

int manage_config_file(int mode, int * port, char * block_size, int * verbosity, char * log_file, char * guidirlog){
	int i, j;
	char * home, config_file[75], conf_setting[20], conf_value[75], line[95];
	FILE * fp;
	
#ifndef __CYGWIN__
	home = getenv("HOME");
	sprintf(config_file, "%s/.wepdecrypt", home);
#else
	sprintf(config_file, "wepdecrypt.conf");
#endif
	
	fp = fopen(config_file, "r");
	
	while(!feof(fp)){			
		i = 0; j = 0;
		while (i < 94){
			line[i] = fgetc(fp);
			if (line[i] == '\n') break;
			i++;
		}
		line[i] = '\0';			
		if (line[0] == '#' || line[0] == '\n' || line[0] <= '\0') continue;
		i = 0;			
		while ((line[i] != '=') && (i < 19)){
			conf_setting[i] = line[i];
			i++;
		}			
		conf_setting[i] = '\0'; i++; 			
		while ((line[i] != '\0') && (i < 95) && (j < 74)){				
			conf_value[j] = line[i];
			j++; i++;
		}
		conf_value[j] = '\0';
			
		if (strncmp(conf_setting,"Port",4) == 0) { if (port != NULL) (*port) = atoi(conf_value); }
		else if (strncmp(conf_setting,"Blocksize",9) == 0) { if (block_size != NULL) strncpy(block_size, conf_value, strlen(conf_value)+1); }
		else if (strncmp(conf_setting,"Verbosity",9) == 0) { if (verbosity != NULL) (*verbosity) = atoi(conf_value); }
		else if (strncmp(conf_setting,"Logfile",7) == 0) { if (log_file != NULL) strncpy(log_file, conf_value, strlen(conf_value)+1); }
		else if (strncmp(conf_setting,"Guidirlog",9) == 0) {if (guidirlog != NULL) strncpy(guidirlog, conf_value, strlen(conf_value)+1); }
		else{
			//Bad data in config file			
			fclose(fp);
			return 0;
		}
	}
	
	return 1;
	fclose(fp);
}
