/*******************************************************************************
* File:   		wepserver.c			                                           
* Date:   		2004-05-21												       
* Author: 		Fernando Tarín					    						   
* Last Modified:	2004-5-23					       						   
*																		       
* Description: Manage server mode.										       
*																		       
*  This program is free software; you can redistribute it and/or modify	       
*  it under the terms of the GNU General Public License as published by	       
*  the Free Software Foundation; either version 2 of the License, or	       
*  (at your option) any later version.									       
*																		       
*  This program is distributed in the hope that it will be useful,		       
*  but WITHOUT ANY WARRANTY; without even the implied warranty of	    	   
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	   
*  GNU Library General Public License for more details.			       		   
*																		       
*  You should have received a copy of the GNU General Public License	       
*  along with this program; if not, write to the Free Software			       
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
********************************************************************************/


#ifndef WEPDECRYPT_WEPSERVER_H
#define WEPDECRYPT_WEPSERVER_H

#include <openssl/bn.h>


typedef struct hosts_list * hosts_list;

struct hosts_list{
	int assigned_blocks;
	unsigned char client_address[17];
	unsigned char start_key[39];
	unsigned char end_key[39];	
	struct hosts_list * next;
};

typedef struct server_data server_data;

struct server_data{
	int mode;
	int verbosity;
	int network_count;
	BIGNUM *block_size;
	char log_file[55];
	unsigned char digest[16];
	unsigned char path[35];
	unsigned char file_name[25];
	unsigned char last_key[13];
};

typedef struct client_data client_data;

struct client_data{
	int option;
	unsigned char digest[16];
	unsigned char decrypted_key[13];
	unsigned char decrypted_bssid[6];	
};

typedef struct sent_data sent_data;

struct sent_data{
	int mode;
	int message;
	unsigned int init_key[13];
	unsigned int end_key[13];
};

void server_init(char * packet_file, int network_count, int cracking_mode, const unsigned char * init_key);

void server_run(void);

void server_stop(void);

#endif
