// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Package serverdiscovery provides a service on Consul servers to discover the set of servers
// currently able to handle incoming requests.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: pbserverdiscovery/serverdiscovery.proto

package pbserverdiscovery

import (
	_ "github.com/hashicorp/consul/proto-public/annotations/ratelimit"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type WatchServersRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Wan being set to true will cause WAN addresses to be sent in the response
	// instead of the LAN addresses which are the default
	Wan           bool `protobuf:"varint,1,opt,name=wan,proto3" json:"wan,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WatchServersRequest) Reset() {
	*x = WatchServersRequest{}
	mi := &file_pbserverdiscovery_serverdiscovery_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WatchServersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchServersRequest) ProtoMessage() {}

func (x *WatchServersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_pbserverdiscovery_serverdiscovery_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchServersRequest.ProtoReflect.Descriptor instead.
func (*WatchServersRequest) Descriptor() ([]byte, []int) {
	return file_pbserverdiscovery_serverdiscovery_proto_rawDescGZIP(), []int{0}
}

func (x *WatchServersRequest) GetWan() bool {
	if x != nil {
		return x.Wan
	}
	return false
}

type WatchServersResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Servers is the list of server address information.
	Servers       []*Server `protobuf:"bytes,1,rep,name=servers,proto3" json:"servers,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WatchServersResponse) Reset() {
	*x = WatchServersResponse{}
	mi := &file_pbserverdiscovery_serverdiscovery_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WatchServersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WatchServersResponse) ProtoMessage() {}

func (x *WatchServersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_pbserverdiscovery_serverdiscovery_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WatchServersResponse.ProtoReflect.Descriptor instead.
func (*WatchServersResponse) Descriptor() ([]byte, []int) {
	return file_pbserverdiscovery_serverdiscovery_proto_rawDescGZIP(), []int{1}
}

func (x *WatchServersResponse) GetServers() []*Server {
	if x != nil {
		return x.Servers
	}
	return nil
}

type Server struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// id is the unique string identifying this server for all time.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// address on the network of the server
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// the consul version of the server
	Version       string `protobuf:"bytes,3,opt,name=version,proto3" json:"version,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Server) Reset() {
	*x = Server{}
	mi := &file_pbserverdiscovery_serverdiscovery_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Server) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Server) ProtoMessage() {}

func (x *Server) ProtoReflect() protoreflect.Message {
	mi := &file_pbserverdiscovery_serverdiscovery_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Server.ProtoReflect.Descriptor instead.
func (*Server) Descriptor() ([]byte, []int) {
	return file_pbserverdiscovery_serverdiscovery_proto_rawDescGZIP(), []int{2}
}

func (x *Server) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Server) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *Server) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

var File_pbserverdiscovery_serverdiscovery_proto protoreflect.FileDescriptor

const file_pbserverdiscovery_serverdiscovery_proto_rawDesc = "" +
	"\n" +
	"'pbserverdiscovery/serverdiscovery.proto\x12 hashicorp.consul.serverdiscovery\x1a%annotations/ratelimit/ratelimit.proto\"'\n" +
	"\x13WatchServersRequest\x12\x10\n" +
	"\x03wan\x18\x01 \x01(\bR\x03wan\"Z\n" +
	"\x14WatchServersResponse\x12B\n" +
	"\aservers\x18\x01 \x03(\v2(.hashicorp.consul.serverdiscovery.ServerR\aservers\"L\n" +
	"\x06Server\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x12\x18\n" +
	"\aaddress\x18\x02 \x01(\tR\aaddress\x12\x18\n" +
	"\aversion\x18\x03 \x01(\tR\aversion2\xa4\x01\n" +
	"\x16ServerDiscoveryService\x12\x89\x01\n" +
	"\fWatchServers\x125.hashicorp.consul.serverdiscovery.WatchServersRequest\x1a6.hashicorp.consul.serverdiscovery.WatchServersResponse\"\b\xe2\x86\x04\x04\b\x02\x10\x060\x01B\x9a\x02\n" +
	"$com.hashicorp.consul.serverdiscoveryB\x14ServerdiscoveryProtoP\x01Z:github.com/hashicorp/consul/proto-public/pbserverdiscovery\xa2\x02\x03HCS\xaa\x02 Hashicorp.Consul.Serverdiscovery\xca\x02 Hashicorp\\Consul\\Serverdiscovery\xe2\x02,Hashicorp\\Consul\\Serverdiscovery\\GPBMetadata\xea\x02\"Hashicorp::Consul::Serverdiscoveryb\x06proto3"

var (
	file_pbserverdiscovery_serverdiscovery_proto_rawDescOnce sync.Once
	file_pbserverdiscovery_serverdiscovery_proto_rawDescData []byte
)

func file_pbserverdiscovery_serverdiscovery_proto_rawDescGZIP() []byte {
	file_pbserverdiscovery_serverdiscovery_proto_rawDescOnce.Do(func() {
		file_pbserverdiscovery_serverdiscovery_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_pbserverdiscovery_serverdiscovery_proto_rawDesc), len(file_pbserverdiscovery_serverdiscovery_proto_rawDesc)))
	})
	return file_pbserverdiscovery_serverdiscovery_proto_rawDescData
}

var file_pbserverdiscovery_serverdiscovery_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_pbserverdiscovery_serverdiscovery_proto_goTypes = []any{
	(*WatchServersRequest)(nil),  // 0: hashicorp.consul.serverdiscovery.WatchServersRequest
	(*WatchServersResponse)(nil), // 1: hashicorp.consul.serverdiscovery.WatchServersResponse
	(*Server)(nil),               // 2: hashicorp.consul.serverdiscovery.Server
}
var file_pbserverdiscovery_serverdiscovery_proto_depIdxs = []int32{
	2, // 0: hashicorp.consul.serverdiscovery.WatchServersResponse.servers:type_name -> hashicorp.consul.serverdiscovery.Server
	0, // 1: hashicorp.consul.serverdiscovery.ServerDiscoveryService.WatchServers:input_type -> hashicorp.consul.serverdiscovery.WatchServersRequest
	1, // 2: hashicorp.consul.serverdiscovery.ServerDiscoveryService.WatchServers:output_type -> hashicorp.consul.serverdiscovery.WatchServersResponse
	2, // [2:3] is the sub-list for method output_type
	1, // [1:2] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_pbserverdiscovery_serverdiscovery_proto_init() }
func file_pbserverdiscovery_serverdiscovery_proto_init() {
	if File_pbserverdiscovery_serverdiscovery_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_pbserverdiscovery_serverdiscovery_proto_rawDesc), len(file_pbserverdiscovery_serverdiscovery_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_pbserverdiscovery_serverdiscovery_proto_goTypes,
		DependencyIndexes: file_pbserverdiscovery_serverdiscovery_proto_depIdxs,
		MessageInfos:      file_pbserverdiscovery_serverdiscovery_proto_msgTypes,
	}.Build()
	File_pbserverdiscovery_serverdiscovery_proto = out.File
	file_pbserverdiscovery_serverdiscovery_proto_goTypes = nil
	file_pbserverdiscovery_serverdiscovery_proto_depIdxs = nil
}
