#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/fortranimpl.h"
/* pepsolve.c */
/* Fortran interface file */

/*
* This file was generated automatically by bfort from the C source
* file.  
 */

#ifdef PETSC_USE_POINTER_CONVERSION
#if defined(__cplusplus)
extern "C" { 
#endif 
extern void *PetscToPointer(void*);
extern int PetscFromPointer(void *);
extern void PetscRmPointer(void*);
#if defined(__cplusplus)
} 
#endif 

#else

#define PetscToPointer(a) (a ? *(PetscFortranAddr *)(a) : 0)
#define PetscFromPointer(a) (PetscFortranAddr)(a)
#define PetscRmPointer(a)
#endif

#include "slepcpep.h"
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pepsolve_ PEPSOLVE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pepsolve_ pepsolve
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pepgetiterationnumber_ PEPGETITERATIONNUMBER
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pepgetiterationnumber_ pepgetiterationnumber
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pepgetconverged_ PEPGETCONVERGED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pepgetconverged_ pepgetconverged
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pepgetconvergedreason_ PEPGETCONVERGEDREASON
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pepgetconvergedreason_ pepgetconvergedreason
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pepgeteigenpair_ PEPGETEIGENPAIR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pepgeteigenpair_ pepgeteigenpair
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pepgeterrorestimate_ PEPGETERRORESTIMATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pepgeterrorestimate_ pepgeterrorestimate
#endif
#ifdef PETSC_HAVE_FORTRAN_CAPS
#define pepcomputeerror_ PEPCOMPUTEERROR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE) && !defined(FORTRANDOUBLEUNDERSCORE)
#define pepcomputeerror_ pepcomputeerror
#endif
/* Provide declarations for malloc/free if needed for strings */
#include <stdlib.h>


/* Definitions of Fortran Wrapper routines */
#if defined(__cplusplus)
extern "C" {
#endif
SLEPC_EXTERN void  pepsolve_(PEP pep, int *ierr)
{
CHKFORTRANNULLOBJECT(pep);
*ierr = PEPSolve(
	(PEP)PetscToPointer((pep) ));
}
SLEPC_EXTERN void  pepgetiterationnumber_(PEP pep,PetscInt *its, int *ierr)
{
CHKFORTRANNULLOBJECT(pep);
CHKFORTRANNULLINTEGER(its);
*ierr = PEPGetIterationNumber(
	(PEP)PetscToPointer((pep) ),its);
}
SLEPC_EXTERN void  pepgetconverged_(PEP pep,PetscInt *nconv, int *ierr)
{
CHKFORTRANNULLOBJECT(pep);
CHKFORTRANNULLINTEGER(nconv);
*ierr = PEPGetConverged(
	(PEP)PetscToPointer((pep) ),nconv);
}
SLEPC_EXTERN void  pepgetconvergedreason_(PEP pep,PEPConvergedReason *reason, int *ierr)
{
CHKFORTRANNULLOBJECT(pep);
*ierr = PEPGetConvergedReason(
	(PEP)PetscToPointer((pep) ),reason);
}
SLEPC_EXTERN void  pepgeteigenpair_(PEP pep,PetscInt *i,PetscScalar *eigr,PetscScalar *eigi,Vec Vr,Vec Vi, int *ierr)
{
CHKFORTRANNULLOBJECT(pep);
CHKFORTRANNULLSCALAR(eigr);
CHKFORTRANNULLSCALAR(eigi);
CHKFORTRANNULLOBJECT(Vr);
CHKFORTRANNULLOBJECT(Vi);
*ierr = PEPGetEigenpair(
	(PEP)PetscToPointer((pep) ),*i,eigr,eigi,
	(Vec)PetscToPointer((Vr) ),
	(Vec)PetscToPointer((Vi) ));
}
SLEPC_EXTERN void  pepgeterrorestimate_(PEP pep,PetscInt *i,PetscReal *errest, int *ierr)
{
CHKFORTRANNULLOBJECT(pep);
CHKFORTRANNULLREAL(errest);
*ierr = PEPGetErrorEstimate(
	(PEP)PetscToPointer((pep) ),*i,errest);
}
SLEPC_EXTERN void  pepcomputeerror_(PEP pep,PetscInt *i,PEPErrorType *type,PetscReal *error, int *ierr)
{
CHKFORTRANNULLOBJECT(pep);
CHKFORTRANNULLREAL(error);
*ierr = PEPComputeError(
	(PEP)PetscToPointer((pep) ),*i,*type,error);
}
#if defined(__cplusplus)
}
#endif
