#ifndef OPENMW_COMPONENTS_TOUTF8_TABLESGEN_HPP
#define OPENMW_COMPONENTS_TOUTF8_TABLESGEN_HPP

namespace ToUTF8
{

    /// Central European and Eastern European languages that use Latin script,
    /// such as Polish, Czech, Slovak, Hungarian, Slovene, Bosnian, Croatian,
    /// Serbian (Latin script), Romanian and Albanian.
    const static signed char windows_1250[] = { 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 1, 3, 0, 0, 0, 0,
        1, 4, 0, 0, 0, 0, 1, 5, 0, 0, 0, 0, 1, 6, 0, 0, 0, 0, 1, 7, 0, 0, 0, 0, 1, 8, 0, 0, 0, 0, 1, 9, 0, 0, 0, 0, 1,
        10, 0, 0, 0, 0, 1, 11, 0, 0, 0, 0, 1, 12, 0, 0, 0, 0, 1, 13, 0, 0, 0, 0, 1, 14, 0, 0, 0, 0, 1, 15, 0, 0, 0, 0,
        1, 16, 0, 0, 0, 0, 1, 17, 0, 0, 0, 0, 1, 18, 0, 0, 0, 0, 1, 19, 0, 0, 0, 0, 1, 20, 0, 0, 0, 0, 1, 21, 0, 0, 0,
        0, 1, 22, 0, 0, 0, 0, 1, 23, 0, 0, 0, 0, 1, 24, 0, 0, 0, 0, 1, 25, 0, 0, 0, 0, 1, 26, 0, 0, 0, 0, 1, 27, 0, 0,
        0, 0, 1, 28, 0, 0, 0, 0, 1, 29, 0, 0, 0, 0, 1, 30, 0, 0, 0, 0, 1, 31, 0, 0, 0, 0, 1, 32, 0, 0, 0, 0, 1, 33, 0,
        0, 0, 0, 1, 34, 0, 0, 0, 0, 1, 35, 0, 0, 0, 0, 1, 36, 0, 0, 0, 0, 1, 37, 0, 0, 0, 0, 1, 38, 0, 0, 0, 0, 1, 39,
        0, 0, 0, 0, 1, 40, 0, 0, 0, 0, 1, 41, 0, 0, 0, 0, 1, 42, 0, 0, 0, 0, 1, 43, 0, 0, 0, 0, 1, 44, 0, 0, 0, 0, 1,
        45, 0, 0, 0, 0, 1, 46, 0, 0, 0, 0, 1, 47, 0, 0, 0, 0, 1, 48, 0, 0, 0, 0, 1, 49, 0, 0, 0, 0, 1, 50, 0, 0, 0, 0,
        1, 51, 0, 0, 0, 0, 1, 52, 0, 0, 0, 0, 1, 53, 0, 0, 0, 0, 1, 54, 0, 0, 0, 0, 1, 55, 0, 0, 0, 0, 1, 56, 0, 0, 0,
        0, 1, 57, 0, 0, 0, 0, 1, 58, 0, 0, 0, 0, 1, 59, 0, 0, 0, 0, 1, 60, 0, 0, 0, 0, 1, 61, 0, 0, 0, 0, 1, 62, 0, 0,
        0, 0, 1, 63, 0, 0, 0, 0, 1, 64, 0, 0, 0, 0, 1, 65, 0, 0, 0, 0, 1, 66, 0, 0, 0, 0, 1, 67, 0, 0, 0, 0, 1, 68, 0,
        0, 0, 0, 1, 69, 0, 0, 0, 0, 1, 70, 0, 0, 0, 0, 1, 71, 0, 0, 0, 0, 1, 72, 0, 0, 0, 0, 1, 73, 0, 0, 0, 0, 1, 74,
        0, 0, 0, 0, 1, 75, 0, 0, 0, 0, 1, 76, 0, 0, 0, 0, 1, 77, 0, 0, 0, 0, 1, 78, 0, 0, 0, 0, 1, 79, 0, 0, 0, 0, 1,
        80, 0, 0, 0, 0, 1, 81, 0, 0, 0, 0, 1, 82, 0, 0, 0, 0, 1, 83, 0, 0, 0, 0, 1, 84, 0, 0, 0, 0, 1, 85, 0, 0, 0, 0,
        1, 86, 0, 0, 0, 0, 1, 87, 0, 0, 0, 0, 1, 88, 0, 0, 0, 0, 1, 89, 0, 0, 0, 0, 1, 90, 0, 0, 0, 0, 1, 91, 0, 0, 0,
        0, 1, 92, 0, 0, 0, 0, 1, 93, 0, 0, 0, 0, 1, 94, 0, 0, 0, 0, 1, 95, 0, 0, 0, 0, 1, 96, 0, 0, 0, 0, 1, 97, 0, 0,
        0, 0, 1, 98, 0, 0, 0, 0, 1, 99, 0, 0, 0, 0, 1, 100, 0, 0, 0, 0, 1, 101, 0, 0, 0, 0, 1, 102, 0, 0, 0, 0, 1, 103,
        0, 0, 0, 0, 1, 104, 0, 0, 0, 0, 1, 105, 0, 0, 0, 0, 1, 106, 0, 0, 0, 0, 1, 107, 0, 0, 0, 0, 1, 108, 0, 0, 0, 0,
        1, 109, 0, 0, 0, 0, 1, 110, 0, 0, 0, 0, 1, 111, 0, 0, 0, 0, 1, 112, 0, 0, 0, 0, 1, 113, 0, 0, 0, 0, 1, 114, 0,
        0, 0, 0, 1, 115, 0, 0, 0, 0, 1, 116, 0, 0, 0, 0, 1, 117, 0, 0, 0, 0, 1, 118, 0, 0, 0, 0, 1, 119, 0, 0, 0, 0, 1,
        120, 0, 0, 0, 0, 1, 121, 0, 0, 0, 0, 1, 122, 0, 0, 0, 0, 1, 123, 0, 0, 0, 0, 1, 124, 0, 0, 0, 0, 1, 125, 0, 0,
        0, 0, 1, 126, 0, 0, 0, 0, 1, 127, 0, 0, 0, 0, 3, -30, -126, -84, 0, 0, 1, 32, 0, 0, 0,
        0, // not part of this charset
        3, -30, -128, -102, 0, 0, 1, 32, 0, 0, 0, 0, // not part of this charset
        3, -30, -128, -98, 0, 0, 3, -30, -128, -90, 0, 0, 3, -30, -128, -96, 0, 0, 3, -30, -128, -95, 0, 0, 1, 32, 0, 0,
        0, 0, // not part of this charset
        3, -30, -128, -80, 0, 0, 2, -59, -96, 0, 0, 0, 3, -30, -128, -71, 0, 0, 2, -59, -102, 0, 0, 0, 2, -59, -92, 0,
        0, 0, 2, -59, -67, 0, 0, 0, 2, -59, -71, 0, 0, 0, 1, 32, 0, 0, 0, 0, // not part of this charset
        3, -30, -128, -104, 0, 0, 3, -30, -128, -103, 0, 0, 3, -30, -128, -100, 0, 0, 3, -30, -128, -99, 0, 0, 3, -30,
        -128, -94, 0, 0, 3, -30, -128, -109, 0, 0, 3, -30, -128, -108, 0, 0, 1, 32, 0, 0, 0,
        0, // not part of this charset
        3, -30, -124, -94, 0, 0, 2, -59, -95, 0, 0, 0, 3, -30, -128, -70, 0, 0, 2, -59, -101, 0, 0, 0, 2, -59, -91, 0,
        0, 0, 2, -59, -66, 0, 0, 0, 2, -59, -70, 0, 0, 0, 2, -62, -96, 0, 0, 0, 2, -53, -121, 0, 0, 0, 2, -53, -104, 0,
        0, 0, 2, -59, -127, 0, 0, 0, 2, -62, -92, 0, 0, 0, 2, -60, -124, 0, 0, 0, 2, -62, -90, 0, 0, 0, 2, -62, -89, 0,
        0, 0, 2, -62, -88, 0, 0, 0, 2, -62, -87, 0, 0, 0, 2, -59, -98, 0, 0, 0, 2, -62, -85, 0, 0, 0, 2, -62, -84, 0, 0,
        0, 2, -62, -83, 0, 0, 0, 2, -62, -82, 0, 0, 0, 2, -59, -69, 0, 0, 0, 2, -62, -80, 0, 0, 0, 2, -62, -79, 0, 0, 0,
        2, -53, -101, 0, 0, 0, 2, -59, -126, 0, 0, 0, 2, -62, -76, 0, 0, 0, 2, -62, -75, 0, 0, 0, 2, -62, -74, 0, 0, 0,
        2, -62, -73, 0, 0, 0, 2, -62, -72, 0, 0, 0, 2, -60, -123, 0, 0, 0, 2, -59, -97, 0, 0, 0, 2, -62, -69, 0, 0, 0,
        2, -60, -67, 0, 0, 0, 2, -53, -99, 0, 0, 0, 2, -60, -66, 0, 0, 0, 2, -59, -68, 0, 0, 0, 2, -59, -108, 0, 0, 0,
        2, -61, -127, 0, 0, 0, 2, -61, -126, 0, 0, 0, 2, -60, -126, 0, 0, 0, 2, -61, -124, 0, 0, 0, 2, -60, -71, 0, 0,
        0, 2, -60, -122, 0, 0, 0, 2, -61, -121, 0, 0, 0, 2, -60, -116, 0, 0, 0, 2, -61, -119, 0, 0, 0, 2, -60, -104, 0,
        0, 0, 2, -61, -117, 0, 0, 0, 2, -60, -102, 0, 0, 0, 2, -61, -115, 0, 0, 0, 2, -61, -114, 0, 0, 0, 2, -60, -114,
        0, 0, 0, 2, -60, -112, 0, 0, 0, 2, -59, -125, 0, 0, 0, 2, -59, -121, 0, 0, 0, 2, -61, -109, 0, 0, 0, 2, -61,
        -108, 0, 0, 0, 2, -59, -112, 0, 0, 0, 2, -61, -106, 0, 0, 0, 2, -61, -105, 0, 0, 0, 2, -59, -104, 0, 0, 0, 2,
        -59, -82, 0, 0, 0, 2, -61, -102, 0, 0, 0, 2, -59, -80, 0, 0, 0, 2, -61, -100, 0, 0, 0, 2, -61, -99, 0, 0, 0, 2,
        -59, -94, 0, 0, 0, 2, -61, -97, 0, 0, 0, 2, -59, -107, 0, 0, 0, 2, -61, -95, 0, 0, 0, 2, -61, -94, 0, 0, 0, 2,
        -60, -125, 0, 0, 0, 2, -61, -92, 0, 0, 0, 2, -60, -70, 0, 0, 0, 2, -60, -121, 0, 0, 0, 2, -61, -89, 0, 0, 0, 2,
        -60, -115, 0, 0, 0, 2, -61, -87, 0, 0, 0, 2, -60, -103, 0, 0, 0, 2, -61, -85, 0, 0, 0, 2, -60, -101, 0, 0, 0, 2,
        -61, -83, 0, 0, 0, 2, -61, -82, 0, 0, 0, 2, -60, -113, 0, 0, 0, 2, -60, -111, 0, 0, 0, 2, -59, -124, 0, 0, 0, 2,
        -59, -120, 0, 0, 0, 2, -61, -77, 0, 0, 0, 2, -61, -76, 0, 0, 0, 2, -59, -111, 0, 0, 0, 2, -61, -74, 0, 0, 0, 2,
        -61, -73, 0, 0, 0, 2, -59, -103, 0, 0, 0, 2, -59, -81, 0, 0, 0, 2, -61, -70, 0, 0, 0, 2, -59, -79, 0, 0, 0, 2,
        -61, -68, 0, 0, 0, 2, -61, -67, 0, 0, 0, 2, -59, -93, 0, 0, 0, 2, -53, -103, 0, 0, 0 };

    /// Cyrillic alphabet such as Russian, Bulgarian, Serbian Cyrillic
    /// and other languages
    const static signed char windows_1251[] = { 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 1, 3, 0, 0, 0, 0,
        1, 4, 0, 0, 0, 0, 1, 5, 0, 0, 0, 0, 1, 6, 0, 0, 0, 0, 1, 7, 0, 0, 0, 0, 1, 8, 0, 0, 0, 0, 1, 9, 0, 0, 0, 0, 1,
        10, 0, 0, 0, 0, 1, 11, 0, 0, 0, 0, 1, 12, 0, 0, 0, 0, 1, 13, 0, 0, 0, 0, 1, 14, 0, 0, 0, 0, 1, 15, 0, 0, 0, 0,
        1, 16, 0, 0, 0, 0, 1, 17, 0, 0, 0, 0, 1, 18, 0, 0, 0, 0, 1, 19, 0, 0, 0, 0, 1, 20, 0, 0, 0, 0, 1, 21, 0, 0, 0,
        0, 1, 22, 0, 0, 0, 0, 1, 23, 0, 0, 0, 0, 1, 24, 0, 0, 0, 0, 1, 25, 0, 0, 0, 0, 1, 26, 0, 0, 0, 0, 1, 27, 0, 0,
        0, 0, 1, 28, 0, 0, 0, 0, 1, 29, 0, 0, 0, 0, 1, 30, 0, 0, 0, 0, 1, 31, 0, 0, 0, 0, 1, 32, 0, 0, 0, 0, 1, 33, 0,
        0, 0, 0, 1, 34, 0, 0, 0, 0, 1, 35, 0, 0, 0, 0, 1, 36, 0, 0, 0, 0, 1, 37, 0, 0, 0, 0, 1, 38, 0, 0, 0, 0, 1, 39,
        0, 0, 0, 0, 1, 40, 0, 0, 0, 0, 1, 41, 0, 0, 0, 0, 1, 42, 0, 0, 0, 0, 1, 43, 0, 0, 0, 0, 1, 44, 0, 0, 0, 0, 1,
        45, 0, 0, 0, 0, 1, 46, 0, 0, 0, 0, 1, 47, 0, 0, 0, 0, 1, 48, 0, 0, 0, 0, 1, 49, 0, 0, 0, 0, 1, 50, 0, 0, 0, 0,
        1, 51, 0, 0, 0, 0, 1, 52, 0, 0, 0, 0, 1, 53, 0, 0, 0, 0, 1, 54, 0, 0, 0, 0, 1, 55, 0, 0, 0, 0, 1, 56, 0, 0, 0,
        0, 1, 57, 0, 0, 0, 0, 1, 58, 0, 0, 0, 0, 1, 59, 0, 0, 0, 0, 1, 60, 0, 0, 0, 0, 1, 61, 0, 0, 0, 0, 1, 62, 0, 0,
        0, 0, 1, 63, 0, 0, 0, 0, 1, 64, 0, 0, 0, 0, 1, 65, 0, 0, 0, 0, 1, 66, 0, 0, 0, 0, 1, 67, 0, 0, 0, 0, 1, 68, 0,
        0, 0, 0, 1, 69, 0, 0, 0, 0, 1, 70, 0, 0, 0, 0, 1, 71, 0, 0, 0, 0, 1, 72, 0, 0, 0, 0, 1, 73, 0, 0, 0, 0, 1, 74,
        0, 0, 0, 0, 1, 75, 0, 0, 0, 0, 1, 76, 0, 0, 0, 0, 1, 77, 0, 0, 0, 0, 1, 78, 0, 0, 0, 0, 1, 79, 0, 0, 0, 0, 1,
        80, 0, 0, 0, 0, 1, 81, 0, 0, 0, 0, 1, 82, 0, 0, 0, 0, 1, 83, 0, 0, 0, 0, 1, 84, 0, 0, 0, 0, 1, 85, 0, 0, 0, 0,
        1, 86, 0, 0, 0, 0, 1, 87, 0, 0, 0, 0, 1, 88, 0, 0, 0, 0, 1, 89, 0, 0, 0, 0, 1, 90, 0, 0, 0, 0, 1, 91, 0, 0, 0,
        0, 1, 92, 0, 0, 0, 0, 1, 93, 0, 0, 0, 0, 1, 94, 0, 0, 0, 0, 1, 95, 0, 0, 0, 0, 1, 96, 0, 0, 0, 0, 1, 97, 0, 0,
        0, 0, 1, 98, 0, 0, 0, 0, 1, 99, 0, 0, 0, 0, 1, 100, 0, 0, 0, 0, 1, 101, 0, 0, 0, 0, 1, 102, 0, 0, 0, 0, 1, 103,
        0, 0, 0, 0, 1, 104, 0, 0, 0, 0, 1, 105, 0, 0, 0, 0, 1, 106, 0, 0, 0, 0, 1, 107, 0, 0, 0, 0, 1, 108, 0, 0, 0, 0,
        1, 109, 0, 0, 0, 0, 1, 110, 0, 0, 0, 0, 1, 111, 0, 0, 0, 0, 1, 112, 0, 0, 0, 0, 1, 113, 0, 0, 0, 0, 1, 114, 0,
        0, 0, 0, 1, 115, 0, 0, 0, 0, 1, 116, 0, 0, 0, 0, 1, 117, 0, 0, 0, 0, 1, 118, 0, 0, 0, 0, 1, 119, 0, 0, 0, 0, 1,
        120, 0, 0, 0, 0, 1, 121, 0, 0, 0, 0, 1, 122, 0, 0, 0, 0, 1, 123, 0, 0, 0, 0, 1, 124, 0, 0, 0, 0, 1, 125, 0, 0,
        0, 0, 1, 126, 0, 0, 0, 0, 1, 127, 0, 0, 0, 0, 2, -48, -126, 0, 0, 0, 2, -48, -125, 0, 0, 0, 3, -30, -128, -102,
        0, 0, 2, -47, -109, 0, 0, 0, 3, -30, -128, -98, 0, 0, 3, -30, -128, -90, 0, 0, 3, -30, -128, -96, 0, 0, 3, -30,
        -128, -95, 0, 0, 3, -30, -126, -84, 0, 0, 3, -30, -128, -80, 0, 0, 2, -48, -119, 0, 0, 0, 3, -30, -128, -71, 0,
        0, 2, -48, -118, 0, 0, 0, 2, -48, -116, 0, 0, 0, 2, -48, -117, 0, 0, 0, 2, -48, -113, 0, 0, 0, 2, -47, -110, 0,
        0, 0, 3, -30, -128, -104, 0, 0, 3, -30, -128, -103, 0, 0, 3, -30, -128, -100, 0, 0, 3, -30, -128, -99, 0, 0, 3,
        -30, -128, -94, 0, 0, 3, -30, -128, -109, 0, 0, 3, -30, -128, -108, 0, 0, 1, 32, 0, 0, 0,
        0, // not part of this charset
        3, -30, -124, -94, 0, 0, 2, -47, -103, 0, 0, 0, 3, -30, -128, -70, 0, 0, 2, -47, -102, 0, 0, 0, 2, -47, -100, 0,
        0, 0, 2, -47, -101, 0, 0, 0, 2, -47, -97, 0, 0, 0, 2, -62, -96, 0, 0, 0, 2, -48, -114, 0, 0, 0, 2, -47, -98, 0,
        0, 0, 2, -48, -120, 0, 0, 0, 2, -62, -92, 0, 0, 0, 2, -46, -112, 0, 0, 0, 2, -62, -90, 0, 0, 0, 2, -62, -89, 0,
        0, 0, 2, -48, -127, 0, 0, 0, 2, -62, -87, 0, 0, 0, 2, -48, -124, 0, 0, 0, 2, -62, -85, 0, 0, 0, 2, -62, -84, 0,
        0, 0, 2, -62, -83, 0, 0, 0, 2, -62, -82, 0, 0, 0, 2, -48, -121, 0, 0, 0, 2, -62, -80, 0, 0, 0, 2, -62, -79, 0,
        0, 0, 2, -48, -122, 0, 0, 0, 2, -47, -106, 0, 0, 0, 2, -46, -111, 0, 0, 0, 2, -62, -75, 0, 0, 0, 2, -62, -74, 0,
        0, 0, 2, -62, -73, 0, 0, 0, 2, -47, -111, 0, 0, 0, 3, -30, -124, -106, 0, 0, 2, -47, -108, 0, 0, 0, 2, -62, -69,
        0, 0, 0, 2, -47, -104, 0, 0, 0, 2, -48, -123, 0, 0, 0, 2, -47, -107, 0, 0, 0, 2, -47, -105, 0, 0, 0, 2, -48,
        -112, 0, 0, 0, 2, -48, -111, 0, 0, 0, 2, -48, -110, 0, 0, 0, 2, -48, -109, 0, 0, 0, 2, -48, -108, 0, 0, 0, 2,
        -48, -107, 0, 0, 0, 2, -48, -106, 0, 0, 0, 2, -48, -105, 0, 0, 0, 2, -48, -104, 0, 0, 0, 2, -48, -103, 0, 0, 0,
        2, -48, -102, 0, 0, 0, 2, -48, -101, 0, 0, 0, 2, -48, -100, 0, 0, 0, 2, -48, -99, 0, 0, 0, 2, -48, -98, 0, 0, 0,
        2, -48, -97, 0, 0, 0, 2, -48, -96, 0, 0, 0, 2, -48, -95, 0, 0, 0, 2, -48, -94, 0, 0, 0, 2, -48, -93, 0, 0, 0, 2,
        -48, -92, 0, 0, 0, 2, -48, -91, 0, 0, 0, 2, -48, -90, 0, 0, 0, 2, -48, -89, 0, 0, 0, 2, -48, -88, 0, 0, 0, 2,
        -48, -87, 0, 0, 0, 2, -48, -86, 0, 0, 0, 2, -48, -85, 0, 0, 0, 2, -48, -84, 0, 0, 0, 2, -48, -83, 0, 0, 0, 2,
        -48, -82, 0, 0, 0, 2, -48, -81, 0, 0, 0, 2, -48, -80, 0, 0, 0, 2, -48, -79, 0, 0, 0, 2, -48, -78, 0, 0, 0, 2,
        -48, -77, 0, 0, 0, 2, -48, -76, 0, 0, 0, 2, -48, -75, 0, 0, 0, 2, -48, -74, 0, 0, 0, 2, -48, -73, 0, 0, 0, 2,
        -48, -72, 0, 0, 0, 2, -48, -71, 0, 0, 0, 2, -48, -70, 0, 0, 0, 2, -48, -69, 0, 0, 0, 2, -48, -68, 0, 0, 0, 2,
        -48, -67, 0, 0, 0, 2, -48, -66, 0, 0, 0, 2, -48, -65, 0, 0, 0, 2, -47, -128, 0, 0, 0, 2, -47, -127, 0, 0, 0, 2,
        -47, -126, 0, 0, 0, 2, -47, -125, 0, 0, 0, 2, -47, -124, 0, 0, 0, 2, -47, -123, 0, 0, 0, 2, -47, -122, 0, 0, 0,
        2, -47, -121, 0, 0, 0, 2, -47, -120, 0, 0, 0, 2, -47, -119, 0, 0, 0, 2, -47, -118, 0, 0, 0, 2, -47, -117, 0, 0,
        0, 2, -47, -116, 0, 0, 0, 2, -47, -115, 0, 0, 0, 2, -47, -114, 0, 0, 0, 2, -47, -113, 0, 0, 0 };

    /// Latin alphabet used by English and some other Western languages
    const static signed char windows_1252[] = { 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 1, 3, 0, 0, 0, 0,
        1, 4, 0, 0, 0, 0, 1, 5, 0, 0, 0, 0, 1, 6, 0, 0, 0, 0, 1, 7, 0, 0, 0, 0, 1, 8, 0, 0, 0, 0, 1, 9, 0, 0, 0, 0, 1,
        10, 0, 0, 0, 0, 1, 11, 0, 0, 0, 0, 1, 12, 0, 0, 0, 0, 1, 13, 0, 0, 0, 0, 1, 14, 0, 0, 0, 0, 1, 15, 0, 0, 0, 0,
        1, 16, 0, 0, 0, 0, 1, 17, 0, 0, 0, 0, 1, 18, 0, 0, 0, 0, 1, 19, 0, 0, 0, 0, 1, 20, 0, 0, 0, 0, 1, 21, 0, 0, 0,
        0, 1, 22, 0, 0, 0, 0, 1, 23, 0, 0, 0, 0, 1, 24, 0, 0, 0, 0, 1, 25, 0, 0, 0, 0, 1, 26, 0, 0, 0, 0, 1, 27, 0, 0,
        0, 0, 1, 28, 0, 0, 0, 0, 1, 29, 0, 0, 0, 0, 1, 30, 0, 0, 0, 0, 1, 31, 0, 0, 0, 0, 1, 32, 0, 0, 0, 0, 1, 33, 0,
        0, 0, 0, 1, 34, 0, 0, 0, 0, 1, 35, 0, 0, 0, 0, 1, 36, 0, 0, 0, 0, 1, 37, 0, 0, 0, 0, 1, 38, 0, 0, 0, 0, 1, 39,
        0, 0, 0, 0, 1, 40, 0, 0, 0, 0, 1, 41, 0, 0, 0, 0, 1, 42, 0, 0, 0, 0, 1, 43, 0, 0, 0, 0, 1, 44, 0, 0, 0, 0, 1,
        45, 0, 0, 0, 0, 1, 46, 0, 0, 0, 0, 1, 47, 0, 0, 0, 0, 1, 48, 0, 0, 0, 0, 1, 49, 0, 0, 0, 0, 1, 50, 0, 0, 0, 0,
        1, 51, 0, 0, 0, 0, 1, 52, 0, 0, 0, 0, 1, 53, 0, 0, 0, 0, 1, 54, 0, 0, 0, 0, 1, 55, 0, 0, 0, 0, 1, 56, 0, 0, 0,
        0, 1, 57, 0, 0, 0, 0, 1, 58, 0, 0, 0, 0, 1, 59, 0, 0, 0, 0, 1, 60, 0, 0, 0, 0, 1, 61, 0, 0, 0, 0, 1, 62, 0, 0,
        0, 0, 1, 63, 0, 0, 0, 0, 1, 64, 0, 0, 0, 0, 1, 65, 0, 0, 0, 0, 1, 66, 0, 0, 0, 0, 1, 67, 0, 0, 0, 0, 1, 68, 0,
        0, 0, 0, 1, 69, 0, 0, 0, 0, 1, 70, 0, 0, 0, 0, 1, 71, 0, 0, 0, 0, 1, 72, 0, 0, 0, 0, 1, 73, 0, 0, 0, 0, 1, 74,
        0, 0, 0, 0, 1, 75, 0, 0, 0, 0, 1, 76, 0, 0, 0, 0, 1, 77, 0, 0, 0, 0, 1, 78, 0, 0, 0, 0, 1, 79, 0, 0, 0, 0, 1,
        80, 0, 0, 0, 0, 1, 81, 0, 0, 0, 0, 1, 82, 0, 0, 0, 0, 1, 83, 0, 0, 0, 0, 1, 84, 0, 0, 0, 0, 1, 85, 0, 0, 0, 0,
        1, 86, 0, 0, 0, 0, 1, 87, 0, 0, 0, 0, 1, 88, 0, 0, 0, 0, 1, 89, 0, 0, 0, 0, 1, 90, 0, 0, 0, 0, 1, 91, 0, 0, 0,
        0, 1, 92, 0, 0, 0, 0, 1, 93, 0, 0, 0, 0, 1, 94, 0, 0, 0, 0, 1, 95, 0, 0, 0, 0, 1, 96, 0, 0, 0, 0, 1, 97, 0, 0,
        0, 0, 1, 98, 0, 0, 0, 0, 1, 99, 0, 0, 0, 0, 1, 100, 0, 0, 0, 0, 1, 101, 0, 0, 0, 0, 1, 102, 0, 0, 0, 0, 1, 103,
        0, 0, 0, 0, 1, 104, 0, 0, 0, 0, 1, 105, 0, 0, 0, 0, 1, 106, 0, 0, 0, 0, 1, 107, 0, 0, 0, 0, 1, 108, 0, 0, 0, 0,
        1, 109, 0, 0, 0, 0, 1, 110, 0, 0, 0, 0, 1, 111, 0, 0, 0, 0, 1, 112, 0, 0, 0, 0, 1, 113, 0, 0, 0, 0, 1, 114, 0,
        0, 0, 0, 1, 115, 0, 0, 0, 0, 1, 116, 0, 0, 0, 0, 1, 117, 0, 0, 0, 0, 1, 118, 0, 0, 0, 0, 1, 119, 0, 0, 0, 0, 1,
        120, 0, 0, 0, 0, 1, 121, 0, 0, 0, 0, 1, 122, 0, 0, 0, 0, 1, 123, 0, 0, 0, 0, 1, 124, 0, 0, 0, 0, 1, 125, 0, 0,
        0, 0, 1, 126, 0, 0, 0, 0, 1, 127, 0, 0, 0, 0, 3, -30, -126, -84, 0, 0, 1, 32, 0, 0, 0,
        0, // not part of this charset
        3, -30, -128, -102, 0, 0, 2, -58, -110, 0, 0, 0, 3, -30, -128, -98, 0, 0, 3, -30, -128, -90, 0, 0, 3, -30, -128,
        -96, 0, 0, 3, -30, -128, -95, 0, 0, 2, -53, -122, 0, 0, 0, 3, -30, -128, -80, 0, 0, 2, -59, -96, 0, 0, 0, 3,
        -30, -128, -71, 0, 0, 2, -59, -110, 0, 0, 0, 1, 32, 0, 0, 0, 0, // not part of this charset
        2, -59, -67, 0, 0, 0, 1, 32, 0, 0, 0, 0, // not part of this charset
        1, 32, 0, 0, 0, 0, // not part of this charset
        3, -30, -128, -104, 0, 0, 3, -30, -128, -103, 0, 0, 3, -30, -128, -100, 0, 0, 3, -30, -128, -99, 0, 0, 3, -30,
        -128, -94, 0, 0, 3, -30, -128, -109, 0, 0, 3, -30, -128, -108, 0, 0, 2, -53, -100, 0, 0, 0, 3, -30, -124, -94,
        0, 0, 2, -59, -95, 0, 0, 0, 3, -30, -128, -70, 0, 0, 2, -59, -109, 0, 0, 0, 1, 32, 0, 0, 0,
        0, // not part of this charset
        2, -59, -66, 0, 0, 0, 2, -59, -72, 0, 0, 0, 2, -62, -96, 0, 0, 0, 2, -62, -95, 0, 0, 0, 2, -62, -94, 0, 0, 0, 2,
        -62, -93, 0, 0, 0, 2, -62, -92, 0, 0, 0, 2, -62, -91, 0, 0, 0, 2, -62, -90, 0, 0, 0, 2, -62, -89, 0, 0, 0, 2,
        -62, -88, 0, 0, 0, 2, -62, -87, 0, 0, 0, 2, -62, -86, 0, 0, 0, 2, -62, -85, 0, 0, 0, 2, -62, -84, 0, 0, 0, 2,
        -62, -83, 0, 0, 0, 2, -62, -82, 0, 0, 0, 2, -62, -81, 0, 0, 0, 2, -62, -80, 0, 0, 0, 2, -62, -79, 0, 0, 0, 2,
        -62, -78, 0, 0, 0, 2, -62, -77, 0, 0, 0, 2, -62, -76, 0, 0, 0, 2, -62, -75, 0, 0, 0, 2, -62, -74, 0, 0, 0, 2,
        -62, -73, 0, 0, 0, 2, -62, -72, 0, 0, 0, 2, -62, -71, 0, 0, 0, 2, -62, -70, 0, 0, 0, 2, -62, -69, 0, 0, 0, 2,
        -62, -68, 0, 0, 0, 2, -62, -67, 0, 0, 0, 2, -62, -66, 0, 0, 0, 2, -62, -65, 0, 0, 0, 2, -61, -128, 0, 0, 0, 2,
        -61, -127, 0, 0, 0, 2, -61, -126, 0, 0, 0, 2, -61, -125, 0, 0, 0, 2, -61, -124, 0, 0, 0, 2, -61, -123, 0, 0, 0,
        2, -61, -122, 0, 0, 0, 2, -61, -121, 0, 0, 0, 2, -61, -120, 0, 0, 0, 2, -61, -119, 0, 0, 0, 2, -61, -118, 0, 0,
        0, 2, -61, -117, 0, 0, 0, 2, -61, -116, 0, 0, 0, 2, -61, -115, 0, 0, 0, 2, -61, -114, 0, 0, 0, 2, -61, -113, 0,
        0, 0, 2, -61, -112, 0, 0, 0, 2, -61, -111, 0, 0, 0, 2, -61, -110, 0, 0, 0, 2, -61, -109, 0, 0, 0, 2, -61, -108,
        0, 0, 0, 2, -61, -107, 0, 0, 0, 2, -61, -106, 0, 0, 0, 2, -61, -105, 0, 0, 0, 2, -61, -104, 0, 0, 0, 2, -61,
        -103, 0, 0, 0, 2, -61, -102, 0, 0, 0, 2, -61, -101, 0, 0, 0, 2, -61, -100, 0, 0, 0, 2, -61, -99, 0, 0, 0, 2,
        -61, -98, 0, 0, 0, 2, -61, -97, 0, 0, 0, 2, -61, -96, 0, 0, 0, 2, -61, -95, 0, 0, 0, 2, -61, -94, 0, 0, 0, 2,
        -61, -93, 0, 0, 0, 2, -61, -92, 0, 0, 0, 2, -61, -91, 0, 0, 0, 2, -61, -90, 0, 0, 0, 2, -61, -89, 0, 0, 0, 2,
        -61, -88, 0, 0, 0, 2, -61, -87, 0, 0, 0, 2, -61, -86, 0, 0, 0, 2, -61, -85, 0, 0, 0, 2, -61, -84, 0, 0, 0, 2,
        -61, -83, 0, 0, 0, 2, -61, -82, 0, 0, 0, 2, -61, -81, 0, 0, 0, 2, -61, -80, 0, 0, 0, 2, -61, -79, 0, 0, 0, 2,
        -61, -78, 0, 0, 0, 2, -61, -77, 0, 0, 0, 2, -61, -76, 0, 0, 0, 2, -61, -75, 0, 0, 0, 2, -61, -74, 0, 0, 0, 2,
        -61, -73, 0, 0, 0, 2, -61, -72, 0, 0, 0, 2, -61, -71, 0, 0, 0, 2, -61, -70, 0, 0, 0, 2, -61, -69, 0, 0, 0, 2,
        -61, -68, 0, 0, 0, 2, -61, -67, 0, 0, 0, 2, -61, -66, 0, 0, 0, 2, -61, -65, 0, 0, 0 };
    const static signed char cp437[] = { 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 1, 3, 0, 0, 0, 0, 1, 4,
        0, 0, 0, 0, 1, 5, 0, 0, 0, 0, 1, 6, 0, 0, 0, 0, 1, 7, 0, 0, 0, 0, 1, 8, 0, 0, 0, 0, 1, 9, 0, 0, 0, 0, 1, 10, 0,
        0, 0, 0, 1, 11, 0, 0, 0, 0, 1, 12, 0, 0, 0, 0, 1, 13, 0, 0, 0, 0, 1, 14, 0, 0, 0, 0, 1, 15, 0, 0, 0, 0, 1, 16,
        0, 0, 0, 0, 1, 17, 0, 0, 0, 0, 1, 18, 0, 0, 0, 0, 1, 19, 0, 0, 0, 0, 1, 20, 0, 0, 0, 0, 1, 21, 0, 0, 0, 0, 1,
        22, 0, 0, 0, 0, 1, 23, 0, 0, 0, 0, 1, 24, 0, 0, 0, 0, 1, 25, 0, 0, 0, 0, 1, 26, 0, 0, 0, 0, 1, 27, 0, 0, 0, 0,
        1, 28, 0, 0, 0, 0, 1, 29, 0, 0, 0, 0, 1, 30, 0, 0, 0, 0, 1, 31, 0, 0, 0, 0, 1, 32, 0, 0, 0, 0, 1, 33, 0, 0, 0,
        0, 1, 34, 0, 0, 0, 0, 1, 35, 0, 0, 0, 0, 1, 36, 0, 0, 0, 0, 1, 37, 0, 0, 0, 0, 1, 38, 0, 0, 0, 0, 1, 39, 0, 0,
        0, 0, 1, 40, 0, 0, 0, 0, 1, 41, 0, 0, 0, 0, 1, 42, 0, 0, 0, 0, 1, 43, 0, 0, 0, 0, 1, 44, 0, 0, 0, 0, 1, 45, 0,
        0, 0, 0, 1, 46, 0, 0, 0, 0, 1, 47, 0, 0, 0, 0, 1, 48, 0, 0, 0, 0, 1, 49, 0, 0, 0, 0, 1, 50, 0, 0, 0, 0, 1, 51,
        0, 0, 0, 0, 1, 52, 0, 0, 0, 0, 1, 53, 0, 0, 0, 0, 1, 54, 0, 0, 0, 0, 1, 55, 0, 0, 0, 0, 1, 56, 0, 0, 0, 0, 1,
        57, 0, 0, 0, 0, 1, 58, 0, 0, 0, 0, 1, 59, 0, 0, 0, 0, 1, 60, 0, 0, 0, 0, 1, 61, 0, 0, 0, 0, 1, 62, 0, 0, 0, 0,
        1, 63, 0, 0, 0, 0, 1, 64, 0, 0, 0, 0, 1, 65, 0, 0, 0, 0, 1, 66, 0, 0, 0, 0, 1, 67, 0, 0, 0, 0, 1, 68, 0, 0, 0,
        0, 1, 69, 0, 0, 0, 0, 1, 70, 0, 0, 0, 0, 1, 71, 0, 0, 0, 0, 1, 72, 0, 0, 0, 0, 1, 73, 0, 0, 0, 0, 1, 74, 0, 0,
        0, 0, 1, 75, 0, 0, 0, 0, 1, 76, 0, 0, 0, 0, 1, 77, 0, 0, 0, 0, 1, 78, 0, 0, 0, 0, 1, 79, 0, 0, 0, 0, 1, 80, 0,
        0, 0, 0, 1, 81, 0, 0, 0, 0, 1, 82, 0, 0, 0, 0, 1, 83, 0, 0, 0, 0, 1, 84, 0, 0, 0, 0, 1, 85, 0, 0, 0, 0, 1, 86,
        0, 0, 0, 0, 1, 87, 0, 0, 0, 0, 1, 88, 0, 0, 0, 0, 1, 89, 0, 0, 0, 0, 1, 90, 0, 0, 0, 0, 1, 91, 0, 0, 0, 0, 1,
        92, 0, 0, 0, 0, 1, 93, 0, 0, 0, 0, 1, 94, 0, 0, 0, 0, 1, 95, 0, 0, 0, 0, 1, 96, 0, 0, 0, 0, 1, 97, 0, 0, 0, 0,
        1, 98, 0, 0, 0, 0, 1, 99, 0, 0, 0, 0, 1, 100, 0, 0, 0, 0, 1, 101, 0, 0, 0, 0, 1, 102, 0, 0, 0, 0, 1, 103, 0, 0,
        0, 0, 1, 104, 0, 0, 0, 0, 1, 105, 0, 0, 0, 0, 1, 106, 0, 0, 0, 0, 1, 107, 0, 0, 0, 0, 1, 108, 0, 0, 0, 0, 1,
        109, 0, 0, 0, 0, 1, 110, 0, 0, 0, 0, 1, 111, 0, 0, 0, 0, 1, 112, 0, 0, 0, 0, 1, 113, 0, 0, 0, 0, 1, 114, 0, 0,
        0, 0, 1, 115, 0, 0, 0, 0, 1, 116, 0, 0, 0, 0, 1, 117, 0, 0, 0, 0, 1, 118, 0, 0, 0, 0, 1, 119, 0, 0, 0, 0, 1,
        120, 0, 0, 0, 0, 1, 121, 0, 0, 0, 0, 1, 122, 0, 0, 0, 0, 1, 123, 0, 0, 0, 0, 1, 124, 0, 0, 0, 0, 1, 125, 0, 0,
        0, 0, 1, 126, 0, 0, 0, 0, 1, 127, 0, 0, 0, 0, 2, -61, -121, 0, 0, 0, 2, -61, -68, 0, 0, 0, 2, -61, -87, 0, 0, 0,
        2, -61, -94, 0, 0, 0, 2, -61, -92, 0, 0, 0, 2, -61, -96, 0, 0, 0, 2, -61, -91, 0, 0, 0, 2, -61, -89, 0, 0, 0, 2,
        -61, -86, 0, 0, 0, 2, -61, -85, 0, 0, 0, 2, -61, -88, 0, 0, 0, 2, -61, -81, 0, 0, 0, 2, -61, -82, 0, 0, 0, 2,
        -61, -84, 0, 0, 0, 2, -61, -124, 0, 0, 0, 2, -61, -123, 0, 0, 0, 2, -61, -119, 0, 0, 0, 2, -61, -90, 0, 0, 0, 2,
        -61, -122, 0, 0, 0, 2, -61, -76, 0, 0, 0, 2, -61, -74, 0, 0, 0, 2, -61, -78, 0, 0, 0, 2, -61, -69, 0, 0, 0, 2,
        -61, -71, 0, 0, 0, 2, -61, -65, 0, 0, 0, 2, -61, -106, 0, 0, 0, 2, -61, -100, 0, 0, 0, 2, -62, -94, 0, 0, 0, 2,
        -62, -93, 0, 0, 0, 2, -62, -91, 0, 0, 0, 3, -30, -126, -89, 0, 0, 2, -58, -110, 0, 0, 0, 2, -61, -95, 0, 0, 0,
        2, -61, -83, 0, 0, 0, 2, -61, -77, 0, 0, 0, 2, -61, -70, 0, 0, 0, 2, -61, -79, 0, 0, 0, 2, -61, -111, 0, 0, 0,
        2, -62, -86, 0, 0, 0, 2, -62, -70, 0, 0, 0, 2, -62, -65, 0, 0, 0, 3, -30, -116, -112, 0, 0, 2, -62, -84, 0, 0,
        0, 2, -62, -67, 0, 0, 0, 2, -62, -68, 0, 0, 0, 2, -62, -95, 0, 0, 0, 2, -62, -85, 0, 0, 0, 2, -62, -69, 0, 0, 0,
        3, -30, -106, -111, 0, 0, 3, -30, -106, -110, 0, 0, 3, -30, -106, -109, 0, 0, 3, -30, -108, -126, 0, 0, 3, -30,
        -108, -92, 0, 0, 3, -30, -107, -95, 0, 0, 3, -30, -107, -94, 0, 0, 3, -30, -107, -106, 0, 0, 3, -30, -107, -107,
        0, 0, 3, -30, -107, -93, 0, 0, 3, -30, -107, -111, 0, 0, 3, -30, -107, -105, 0, 0, 3, -30, -107, -99, 0, 0, 3,
        -30, -107, -100, 0, 0, 3, -30, -107, -101, 0, 0, 3, -30, -108, -112, 0, 0, 3, -30, -108, -108, 0, 0, 3, -30,
        -108, -76, 0, 0, 3, -30, -108, -84, 0, 0, 3, -30, -108, -100, 0, 0, 3, -30, -108, -128, 0, 0, 3, -30, -108, -68,
        0, 0, 3, -30, -107, -98, 0, 0, 3, -30, -107, -97, 0, 0, 3, -30, -107, -102, 0, 0, 3, -30, -107, -108, 0, 0, 3,
        -30, -107, -87, 0, 0, 3, -30, -107, -90, 0, 0, 3, -30, -107, -96, 0, 0, 3, -30, -107, -112, 0, 0, 3, -30, -107,
        -84, 0, 0, 3, -30, -107, -89, 0, 0, 3, -30, -107, -88, 0, 0, 3, -30, -107, -92, 0, 0, 3, -30, -107, -91, 0, 0,
        3, -30, -107, -103, 0, 0, 3, -30, -107, -104, 0, 0, 3, -30, -107, -110, 0, 0, 3, -30, -107, -109, 0, 0, 3, -30,
        -107, -85, 0, 0, 3, -30, -107, -86, 0, 0, 3, -30, -108, -104, 0, 0, 3, -30, -108, -116, 0, 0, 3, -30, -106,
        -120, 0, 0, 3, -30, -106, -124, 0, 0, 3, -30, -106, -116, 0, 0, 3, -30, -106, -112, 0, 0, 3, -30, -106, -128, 0,
        0, 2, -50, -79, 0, 0, 0, 2, -61, -97, 0, 0, 0, 2, -50, -109, 0, 0, 0, 2, -49, -128, 0, 0, 0, 2, -50, -93, 0, 0,
        0, 2, -49, -125, 0, 0, 0, 2, -62, -75, 0, 0, 0, 2, -49, -124, 0, 0, 0, 2, -50, -90, 0, 0, 0, 2, -50, -104, 0, 0,
        0, 2, -50, -87, 0, 0, 0, 2, -50, -76, 0, 0, 0, 3, -30, -120, -98, 0, 0, 2, -49, -122, 0, 0, 0, 2, -50, -75, 0,
        0, 0, 3, -30, -120, -87, 0, 0, 3, -30, -119, -95, 0, 0, 2, -62, -79, 0, 0, 0, 3, -30, -119, -91, 0, 0, 3, -30,
        -119, -92, 0, 0, 3, -30, -116, -96, 0, 0, 3, -30, -116, -95, 0, 0, 2, -61, -73, 0, 0, 0, 3, -30, -119, -120, 0,
        0, 2, -62, -80, 0, 0, 0, 3, -30, -120, -103, 0, 0, 2, -62, -73, 0, 0, 0, 3, -30, -120, -102, 0, 0, 3, -30, -127,
        -65, 0, 0, 2, -62, -78, 0, 0, 0, 3, -30, -106, -96, 0, 0, 2, -62, -96, 0, 0, 0 };

}

#endif
