/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2023 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * TransfDifsHelixV2Iteration  fragmentarium code, mdifs by knighty (jan 2012)
 * M3D difs code by darkbeam
 * and http://www.iquilezles.org/www/articles/distfunctions/distfunctions.htm

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_difs_helix_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDIFSHelixV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL temp;
	REAL4 zc = z;

	zc *= fractal->transformCommon.scale1;
	aux->DE *= fractal->transformCommon.scale1;

	// torus
	REAL ang = atan2(zc.y, zc.x) * M_PI_2x_INV_F;
	zc.y = native_sqrt(zc.x * zc.x + zc.y * zc.y) - fractal->transformCommon.radius1;
	zc.y = zc.y + fractal->transformCommon.scaleC0 * zc.z;

	// vert helix
	if (fractal->transformCommon.functionEnabledAx)
	{
		REAL Voff = fractal->transformCommon.offsetA2;
		temp = zc.z - Voff * ang * fractal->transformCommon.int1 + Voff * 0.5f;
		zc.z = temp - Voff * floor(temp / Voff) - Voff * 0.5f;
	}
	// stretch around helix
	if (fractal->transformCommon.functionEnabledAy)
	{
		if (!fractal->transformCommon.functionEnabledAyFalse)
			zc.x = fractal->transformCommon.offset1;
		else
		{
			temp = fractal->transformCommon.scaleA2 * ang + fractal->transformCommon.offset1;
			zc.x = temp - 2.0f * floor(temp * 0.5f) - 1.0f;
		}
	}

	zc.x *= fractal->transformCommon.scaleG1;

	// twist
	if (fractal->transformCommon.functionEnabledAz)
	{
		ang *= M_PI_F * fractal->transformCommon.int2;
		REAL cosA = native_cos(ang);
		REAL sinB = native_sin(ang);
		REAL a;
		REAL b;
		if (!fractal->transformCommon.functionEnabledKFalse)
		{
			if (!fractal->transformCommon.functionEnabledSwFalse)
			{
				a = zc.y;
				b = zc.z;
			}
			else
			{
				a = zc.z;
				b = zc.y;
			}
			zc.y = b * cosA + a * sinB;
			zc.z = a * cosA - b * sinB;
		}
		else
		{
			if (!fractal->transformCommon.functionEnabledSwFalse)
			{
				a = zc.x;
				b = zc.z;
			}
			else
			{
				a = zc.z;
				b = zc.x;
			}
			zc.x = b * cosA + a * sinB;
			zc.z = a * cosA - b * sinB;
		}
		if (fractal->transformCommon.functionEnabledPFalse) zc.x = zc.z;
	}
	if (fractal->transformCommon.functionEnabledDFalse)
	{
		temp = zc.x;
		zc.x = zc.z;
		zc.z = temp;
	}
	if (fractal->transformCommon.functionEnabledFalse)
	{
		zc = fractal->transformCommon.offset000 - fabs(zc);
	}

	REAL4 d = fabs(zc);
	d.x = max(d.x - fractal->transformCommon.offsetA1, 0.0f);
	d.y = max(d.y - fractal->transformCommon.offset01, 0.0f);
	d.z = max(d.z - fractal->transformCommon.offsetp1, 0.0f);

	REAL rDE;
	if (!fractal->transformCommon.functionEnabledCFalse)
	{
		if (!fractal->transformCommon.functionEnabledTFalse)
		{
			rDE = length(d);
		}
		else
		{
			rDE = max(d.x, max(d.y, d.z));
		}
	}
	else
	{
		if (!fractal->transformCommon.functionEnabledBFalse)
			rDE = d.x * d.x + d.y * d.y;
		else
			rDE = d.x + d.y;

		rDE = native_sqrt(rDE) - fractal->transformCommon.offset0;
		if (fractal->transformCommon.functionEnabledNFalse) rDE = native_sqrt(rDE * rDE + d.z);

		if (fractal->transformCommon.functionEnabledOFalse) rDE = native_sqrt(rDE * rDE + d.z * d.z);

		if (fractal->transformCommon.functionEnabledMFalse) rDE = max(fabs(rDE), fabs(zc.z));

		if (fractal->transformCommon.functionEnabledSFalse) rDE = max(fabs(rDE), zc.z * zc.z);
	}

	rDE -= fractal->transformCommon.offset0005;
	rDE = rDE / (aux->DE + fractal->analyticDE.offset0);
	if (fractal->transformCommon.functionEnabledJFalse) // z clip
	{
		rDE = max(
			fabs(aux->const_c.z - fractal->transformCommon.offsetE0) - fractal->transformCommon.offset2,
			rDE);
	}

	if (!fractal->analyticDE.enabledFalse)
		aux->dist = min(aux->dist, rDE);
	else
		aux->dist = rDE;

	if (fractal->transformCommon.functionEnabledZcFalse
			&& aux->i >= fractal->transformCommon.startIterationsZc
			&& aux->i < fractal->transformCommon.stopIterationsZc)
		z = zc;

	if (fractal->foldColor.auxColorEnabled)
	{
		if (!fractal->transformCommon.functionEnabledGFalse)
		{
			ang =
				(M_PI_F - 2.0f * fabs(atan(fractal->foldColor.difs1 * zc.y / zc.z))) * 4.0f * M_PI_2x_INV_F;
			if (fmod(ang, 2.0f) < 1.0f)
				aux->color += fractal->foldColor.difs0000.z;
			else
				aux->color += fractal->foldColor.difs0000.w;
		}
		else
		{
			aux->color += fractal->foldColor.difs0000.z * (zc.z * zc.z);
			aux->color += fractal->foldColor.difs0000.w * (zc.y * zc.y);
		}
	}
	return z;
}