/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2025 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * http://www.iquilezles.org/www/articles/distfunctions/distfunctions.htm

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_difs_hexprism.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfDIFSHexprismIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL lenX = fractal->transformCommon.offset1;
	REAL lenY = fractal->transformCommon.offsetA1;
	REAL4 zc = fabs(z);

	// swap axis
	if (fractal->transformCommon.functionEnabledSFalse)
	{
		REAL temp = zc.x;
		zc.x = zc.y;
		zc.y = temp;
	}

	// swap axis
	if (fractal->transformCommon.functionEnabledSwFalse)
	{
		REAL temp = zc.x;
		zc.x = zc.z;
		zc.z = temp;
	}

	if (fractal->transformCommon.rotation2EnabledFalse
			&& aux->i >= fractal->transformCommon.startIterationsR
			&& aux->i < fractal->transformCommon.stopIterationsR)
	{
		zc = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, zc);
	}

	REAL4 k = (REAL4){-SQRT_3_4_F, 0.5f, SQRT_1_3_F, 0.0f};

	REAL tp = 2.0f * min(k.x * zc.x + k.y * zc.y, 0.0f);
	zc.x -= tp * k.x;
	zc.y -= tp * k.y;

	REAL dx = zc.x - clamp(zc.x, -k.z * lenX, k.z * lenX);
	REAL dy = zc.y - lenX;

	tp = native_sqrt(dx * dx + dy * dy);
	dx = tp * sign(zc.y - lenX) + fractal->transformCommon.offsetB0;
	dy = zc.z - lenY + fractal->transformCommon.offsetB0;
	tp = dx;
	REAL colIn = 0.0f;
	if (fractal->transformCommon.functionEnabledDFalse)
	{
		colIn = dx + fractal->transformCommon.offset0;
		dx = fabs(dx) - fractal->transformCommon.offset0;

		if (fractal->transformCommon.functionEnabledBFalse) dx = max(dx, tp);
	}

	REAL maxdx = max(dx, 0.0f);
	REAL maxdy = max(dy, 0.0f);

	tp = native_sqrt(maxdx * maxdx + maxdy * maxdy);
	aux->DE0 = min(max(dx, dy), 0.0f) + tp;

	REAL colDist = aux->dist;
	aux->dist = min(aux->dist,
		aux->DE0 / (aux->DE + fractal->analyticDE.offset0) - fractal->transformCommon.offsetB0);

	if (fractal->foldColor.auxColorEnabledFalse && colDist != aux->dist
			&& aux->i >= fractal->foldColor.startIterationsA
			&& aux->i < fractal->foldColor.stopIterationsA)
	{
		REAL addCol = fractal->foldColor.difs0000.y;
		if (fractal->foldColor.auxColorEnabledAFalse)
		{
			if (colIn < maxdx) addCol = fractal->foldColor.difs0000.z;
			if (lenY - fractal->foldColor.difs0 < zc.z) addCol = fractal->foldColor.difs0000.w;
		}
		if (!fractal->foldColor.auxColorEnabledBFalse)
		{
			aux->color = addCol;
		}
		else
		{
			aux->color += addCol + fractal->foldColor.difs0000.x; // aux->color default 1
		}
	}
	return z;
}