/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2022 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Low res mode transform from Mandelbulb3D.
 * @reference
 * https://fractalforums.org/code-snippets-fragments/74/low-resolution-effect/4687

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_transf_low_res_mode.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 TransfLowResModeIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	z *= fractal->transformCommon.scale25;
	REAL4 zi = z;
	if (fractal->transformCommon.functionEnabledx) zi.x = round(zi.x);
	if (fractal->transformCommon.functionEnabledy) zi.y = round(zi.y);
	if (fractal->transformCommon.functionEnabledz) zi.z = round(zi.z);
	if (fractal->transformCommon.functionEnabledwFalse) zi.w = round(z.w);
	REAL4 zf = z - zi;

	z = (fractal->transformCommon.scale16 * zf * zf * zf * zf * zf + zi)
			/ fractal->transformCommon.scale25;

	if (fractal->analyticDE.enabledFalse)
	{
		aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset0;
	}
	return z;
}