// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The body of an <code>InvokeModel</code> API request for token counting. This structure mirrors the input format for the <code>InvokeModel</code> operation, allowing you to count tokens for raw text inference requests.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct InvokeModelTokensRequest {
    /// <p>The request body to count tokens for, formatted according to the model's expected input format. To learn about the input format for different models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Model inference parameters and responses</a>.</p>
    pub body: ::aws_smithy_types::Blob,
}
impl InvokeModelTokensRequest {
    /// <p>The request body to count tokens for, formatted according to the model's expected input format. To learn about the input format for different models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Model inference parameters and responses</a>.</p>
    pub fn body(&self) -> &::aws_smithy_types::Blob {
        &self.body
    }
}
impl ::std::fmt::Debug for InvokeModelTokensRequest {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeModelTokensRequest");
        formatter.field("body", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl InvokeModelTokensRequest {
    /// Creates a new builder-style object to manufacture [`InvokeModelTokensRequest`](crate::types::InvokeModelTokensRequest).
    pub fn builder() -> crate::types::builders::InvokeModelTokensRequestBuilder {
        crate::types::builders::InvokeModelTokensRequestBuilder::default()
    }
}

/// A builder for [`InvokeModelTokensRequest`](crate::types::InvokeModelTokensRequest).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct InvokeModelTokensRequestBuilder {
    pub(crate) body: ::std::option::Option<::aws_smithy_types::Blob>,
}
impl InvokeModelTokensRequestBuilder {
    /// <p>The request body to count tokens for, formatted according to the model's expected input format. To learn about the input format for different models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Model inference parameters and responses</a>.</p>
    /// This field is required.
    pub fn body(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.body = ::std::option::Option::Some(input);
        self
    }
    /// <p>The request body to count tokens for, formatted according to the model's expected input format. To learn about the input format for different models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Model inference parameters and responses</a>.</p>
    pub fn set_body(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.body = input;
        self
    }
    /// <p>The request body to count tokens for, formatted according to the model's expected input format. To learn about the input format for different models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Model inference parameters and responses</a>.</p>
    pub fn get_body(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.body
    }
    /// Consumes the builder and constructs a [`InvokeModelTokensRequest`](crate::types::InvokeModelTokensRequest).
    /// This method will fail if any of the following fields are not set:
    /// - [`body`](crate::types::builders::InvokeModelTokensRequestBuilder::body)
    pub fn build(self) -> ::std::result::Result<crate::types::InvokeModelTokensRequest, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::InvokeModelTokensRequest {
            body: self.body.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "body",
                    "body was not specified but it is required when building InvokeModelTokensRequest",
                )
            })?,
        })
    }
}
impl ::std::fmt::Debug for InvokeModelTokensRequestBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("InvokeModelTokensRequestBuilder");
        formatter.field("body", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
