package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateResult invokes the aegis.OperateResult API synchronously
// api document: https://help.aliyun.com/api/aegis/operateresult.html
func (client *Client) OperateResult(request *OperateResultRequest) (response *OperateResultResponse, err error) {
	response = CreateOperateResultResponse()
	err = client.DoAction(request, response)
	return
}

// OperateResultWithChan invokes the aegis.OperateResult API asynchronously
// api document: https://help.aliyun.com/api/aegis/operateresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OperateResultWithChan(request *OperateResultRequest) (<-chan *OperateResultResponse, <-chan error) {
	responseChan := make(chan *OperateResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateResultWithCallback invokes the aegis.OperateResult API asynchronously
// api document: https://help.aliyun.com/api/aegis/operateresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OperateResultWithCallback(request *OperateResultRequest, callback func(response *OperateResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateResultResponse
		var err error
		defer close(result)
		response, err = client.OperateResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateResultRequest is the request struct for api OperateResult
type OperateResultRequest struct {
	*requests.RpcRequest
	SourceIp string           `position:"Query" name:"SourceIp"`
	Ids      string           `position:"Query" name:"Ids"`
	Status   requests.Integer `position:"Query" name:"Status"`
}

// OperateResultResponse is the response struct for api OperateResult
type OperateResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOperateResultRequest creates a request to invoke OperateResult API
func CreateOperateResultRequest() (request *OperateResultRequest) {
	request = &OperateResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "OperateResult", "vipaegis", "openAPI")
	return
}

// CreateOperateResultResponse creates a response to parse from OperateResult response
func CreateOperateResultResponse() (response *OperateResultResponse) {
	response = &OperateResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
