package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLoadBalancerAttribute invokes the alb.UpdateLoadBalancerAttribute API synchronously
func (client *Client) UpdateLoadBalancerAttribute(request *UpdateLoadBalancerAttributeRequest) (response *UpdateLoadBalancerAttributeResponse, err error) {
	response = CreateUpdateLoadBalancerAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLoadBalancerAttributeWithChan invokes the alb.UpdateLoadBalancerAttribute API asynchronously
func (client *Client) UpdateLoadBalancerAttributeWithChan(request *UpdateLoadBalancerAttributeRequest) (<-chan *UpdateLoadBalancerAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateLoadBalancerAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLoadBalancerAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLoadBalancerAttributeWithCallback invokes the alb.UpdateLoadBalancerAttribute API asynchronously
func (client *Client) UpdateLoadBalancerAttributeWithCallback(request *UpdateLoadBalancerAttributeRequest, callback func(response *UpdateLoadBalancerAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLoadBalancerAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateLoadBalancerAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLoadBalancerAttributeRequest is the request struct for api UpdateLoadBalancerAttribute
type UpdateLoadBalancerAttributeRequest struct {
	*requests.RpcRequest
	ClientToken                  string                                                  `position:"Query" name:"ClientToken"`
	ModificationProtectionConfig UpdateLoadBalancerAttributeModificationProtectionConfig `position:"Query" name:"ModificationProtectionConfig"  type:"Struct"`
	LoadBalancerName             string                                                  `position:"Query" name:"LoadBalancerName"`
	DryRun                       requests.Boolean                                        `position:"Query" name:"DryRun"`
	LoadBalancerId               string                                                  `position:"Query" name:"LoadBalancerId"`
}

// UpdateLoadBalancerAttributeModificationProtectionConfig is a repeated param struct in UpdateLoadBalancerAttributeRequest
type UpdateLoadBalancerAttributeModificationProtectionConfig struct {
	Reason string `name:"Reason"`
	Status string `name:"Status"`
}

// UpdateLoadBalancerAttributeResponse is the response struct for api UpdateLoadBalancerAttribute
type UpdateLoadBalancerAttributeResponse struct {
	*responses.BaseResponse
	JobId     string `json:"JobId" xml:"JobId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLoadBalancerAttributeRequest creates a request to invoke UpdateLoadBalancerAttribute API
func CreateUpdateLoadBalancerAttributeRequest() (request *UpdateLoadBalancerAttributeRequest) {
	request = &UpdateLoadBalancerAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "UpdateLoadBalancerAttribute", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLoadBalancerAttributeResponse creates a response to parse from UpdateLoadBalancerAttribute response
func CreateUpdateLoadBalancerAttributeResponse() (response *UpdateLoadBalancerAttributeResponse) {
	response = &UpdateLoadBalancerAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
