package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyUserLevelsOfSkillGroup invokes the ccc.ModifyUserLevelsOfSkillGroup API synchronously
func (client *Client) ModifyUserLevelsOfSkillGroup(request *ModifyUserLevelsOfSkillGroupRequest) (response *ModifyUserLevelsOfSkillGroupResponse, err error) {
	response = CreateModifyUserLevelsOfSkillGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyUserLevelsOfSkillGroupWithChan invokes the ccc.ModifyUserLevelsOfSkillGroup API asynchronously
func (client *Client) ModifyUserLevelsOfSkillGroupWithChan(request *ModifyUserLevelsOfSkillGroupRequest) (<-chan *ModifyUserLevelsOfSkillGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyUserLevelsOfSkillGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyUserLevelsOfSkillGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyUserLevelsOfSkillGroupWithCallback invokes the ccc.ModifyUserLevelsOfSkillGroup API asynchronously
func (client *Client) ModifyUserLevelsOfSkillGroupWithCallback(request *ModifyUserLevelsOfSkillGroupRequest, callback func(response *ModifyUserLevelsOfSkillGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyUserLevelsOfSkillGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyUserLevelsOfSkillGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyUserLevelsOfSkillGroupRequest is the request struct for api ModifyUserLevelsOfSkillGroup
type ModifyUserLevelsOfSkillGroupRequest struct {
	*requests.RpcRequest
	UserLevelList string `position:"Query" name:"UserLevelList"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	SkillGroupId  string `position:"Query" name:"SkillGroupId"`
}

// ModifyUserLevelsOfSkillGroupResponse is the response struct for api ModifyUserLevelsOfSkillGroup
type ModifyUserLevelsOfSkillGroupResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	Data           string `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyUserLevelsOfSkillGroupRequest creates a request to invoke ModifyUserLevelsOfSkillGroup API
func CreateModifyUserLevelsOfSkillGroupRequest() (request *ModifyUserLevelsOfSkillGroupRequest) {
	request = &ModifyUserLevelsOfSkillGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ModifyUserLevelsOfSkillGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyUserLevelsOfSkillGroupResponse creates a response to parse from ModifyUserLevelsOfSkillGroup response
func CreateModifyUserLevelsOfSkillGroupResponse() (response *ModifyUserLevelsOfSkillGroupResponse) {
	response = &ModifyUserLevelsOfSkillGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
