package clickhouse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckScaleOutBalanced invokes the clickhouse.CheckScaleOutBalanced API synchronously
func (client *Client) CheckScaleOutBalanced(request *CheckScaleOutBalancedRequest) (response *CheckScaleOutBalancedResponse, err error) {
	response = CreateCheckScaleOutBalancedResponse()
	err = client.DoAction(request, response)
	return
}

// CheckScaleOutBalancedWithChan invokes the clickhouse.CheckScaleOutBalanced API asynchronously
func (client *Client) CheckScaleOutBalancedWithChan(request *CheckScaleOutBalancedRequest) (<-chan *CheckScaleOutBalancedResponse, <-chan error) {
	responseChan := make(chan *CheckScaleOutBalancedResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckScaleOutBalanced(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckScaleOutBalancedWithCallback invokes the clickhouse.CheckScaleOutBalanced API asynchronously
func (client *Client) CheckScaleOutBalancedWithCallback(request *CheckScaleOutBalancedRequest, callback func(response *CheckScaleOutBalancedResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckScaleOutBalancedResponse
		var err error
		defer close(result)
		response, err = client.CheckScaleOutBalanced(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckScaleOutBalancedRequest is the request struct for api CheckScaleOutBalanced
type CheckScaleOutBalancedRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CheckScaleOutBalancedResponse is the response struct for api CheckScaleOutBalanced
type CheckScaleOutBalancedResponse struct {
	*responses.BaseResponse
	TotalCount   int          `json:"TotalCount" xml:"TotalCount"`
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	PageSize     int          `json:"PageSize" xml:"PageSize"`
	PageNumber   int          `json:"PageNumber" xml:"PageNumber"`
	CheckCode    string       `json:"CheckCode" xml:"CheckCode"`
	TimeDuration string       `json:"TimeDuration" xml:"TimeDuration"`
	TableDetails TableDetails `json:"TableDetails" xml:"TableDetails"`
}

// CreateCheckScaleOutBalancedRequest creates a request to invoke CheckScaleOutBalanced API
func CreateCheckScaleOutBalancedRequest() (request *CheckScaleOutBalancedRequest) {
	request = &CheckScaleOutBalancedRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("clickhouse", "2019-11-11", "CheckScaleOutBalanced", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckScaleOutBalancedResponse creates a response to parse from CheckScaleOutBalanced response
func CreateCheckScaleOutBalancedResponse() (response *CheckScaleOutBalancedResponse) {
	response = &CheckScaleOutBalancedResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
