package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddPhoneNumberEx invokes the cloudcallcenter.AddPhoneNumberEx API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/addphonenumberex.html
func (client *Client) AddPhoneNumberEx(request *AddPhoneNumberExRequest) (response *AddPhoneNumberExResponse, err error) {
	response = CreateAddPhoneNumberExResponse()
	err = client.DoAction(request, response)
	return
}

// AddPhoneNumberExWithChan invokes the cloudcallcenter.AddPhoneNumberEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/addphonenumberex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddPhoneNumberExWithChan(request *AddPhoneNumberExRequest) (<-chan *AddPhoneNumberExResponse, <-chan error) {
	responseChan := make(chan *AddPhoneNumberExResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddPhoneNumberEx(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddPhoneNumberExWithCallback invokes the cloudcallcenter.AddPhoneNumberEx API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/addphonenumberex.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddPhoneNumberExWithCallback(request *AddPhoneNumberExRequest, callback func(response *AddPhoneNumberExResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddPhoneNumberExResponse
		var err error
		defer close(result)
		response, err = client.AddPhoneNumberEx(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddPhoneNumberExRequest is the request struct for api AddPhoneNumberEx
type AddPhoneNumberExRequest struct {
	*requests.RpcRequest
	ContactFlowId string `position:"Query" name:"ContactFlowId"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	Usage         string `position:"Query" name:"Usage"`
	PhoneNumber   string `position:"Query" name:"PhoneNumber"`
}

// AddPhoneNumberExResponse is the response struct for api AddPhoneNumberEx
type AddPhoneNumberExResponse struct {
	*responses.BaseResponse
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	Success        bool        `json:"Success" xml:"Success"`
	Code           string      `json:"Code" xml:"Code"`
	Message        string      `json:"Message" xml:"Message"`
	HttpStatusCode int         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	PhoneNumber    PhoneNumber `json:"PhoneNumber" xml:"PhoneNumber"`
}

// CreateAddPhoneNumberExRequest creates a request to invoke AddPhoneNumberEx API
func CreateAddPhoneNumberExRequest() (request *AddPhoneNumberExRequest) {
	request = &AddPhoneNumberExRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "AddPhoneNumberEx", "", "")
	request.Method = requests.POST
	return
}

// CreateAddPhoneNumberExResponse creates a response to parse from AddPhoneNumberEx response
func CreateAddPhoneNumberExResponse() (response *AddPhoneNumberExResponse) {
	response = &AddPhoneNumberExResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
