package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// Apply400CorpIdentify invokes the cloudcallcenter.Apply400CorpIdentify API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/apply400corpidentify.html
func (client *Client) Apply400CorpIdentify(request *Apply400CorpIdentifyRequest) (response *Apply400CorpIdentifyResponse, err error) {
	response = CreateApply400CorpIdentifyResponse()
	err = client.DoAction(request, response)
	return
}

// Apply400CorpIdentifyWithChan invokes the cloudcallcenter.Apply400CorpIdentify API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/apply400corpidentify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) Apply400CorpIdentifyWithChan(request *Apply400CorpIdentifyRequest) (<-chan *Apply400CorpIdentifyResponse, <-chan error) {
	responseChan := make(chan *Apply400CorpIdentifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.Apply400CorpIdentify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// Apply400CorpIdentifyWithCallback invokes the cloudcallcenter.Apply400CorpIdentify API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/apply400corpidentify.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) Apply400CorpIdentifyWithCallback(request *Apply400CorpIdentifyRequest, callback func(response *Apply400CorpIdentifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *Apply400CorpIdentifyResponse
		var err error
		defer close(result)
		response, err = client.Apply400CorpIdentify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// Apply400CorpIdentifyRequest is the request struct for api Apply400CorpIdentify
type Apply400CorpIdentifyRequest struct {
	*requests.RpcRequest
	CorpCertNumber           string `position:"Query" name:"CorpCertNumber"`
	CorpRegisteredEffDate    string `position:"Query" name:"CorpRegisteredEffDate"`
	CorpCertType             string `position:"Query" name:"CorpCertType"`
	CorpRegisteredAddrCity   string `position:"Query" name:"CorpRegisteredAddrCity"`
	CorpRegisteredAddrDetail string `position:"Query" name:"CorpRegisteredAddrDetail"`
	LegalPersonName          string `position:"Query" name:"LegalPersonName"`
	LegalPersonCertEffDate   string `position:"Query" name:"LegalPersonCertEffDate"`
	BusinessLicensePic       string `position:"Query" name:"BusinessLicensePic"`
	CorpRegisteredAddrProv   string `position:"Query" name:"CorpRegisteredAddrProv"`
	SpecIdArray              string `position:"Query" name:"SpecIdArray"`
	LegalPersonCertType      string `position:"Query" name:"LegalPersonCertType"`
	CorpNumber               string `position:"Query" name:"CorpNumber"`
	OldOrderId               string `position:"Query" name:"OldOrderId"`
	CorpRegisteredAddrArea   string `position:"Query" name:"CorpRegisteredAddrArea"`
	LegalPersonCertPic       string `position:"Query" name:"LegalPersonCertPic"`
	LegalPersonCertExpDate   string `position:"Query" name:"LegalPersonCertExpDate"`
	CorpRegisteredExpDate    string `position:"Query" name:"CorpRegisteredExpDate"`
	CorpName                 string `position:"Query" name:"CorpName"`
	ApplyRemark              string `position:"Query" name:"ApplyRemark"`
	LegalPersonPhoneNumber   string `position:"Query" name:"LegalPersonPhoneNumber"`
	LegalPersonCertNumber    string `position:"Query" name:"LegalPersonCertNumber"`
}

// Apply400CorpIdentifyResponse is the response struct for api Apply400CorpIdentify
type Apply400CorpIdentifyResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           string `json:"Data" xml:"Data"`
}

// CreateApply400CorpIdentifyRequest creates a request to invoke Apply400CorpIdentify API
func CreateApply400CorpIdentifyRequest() (request *Apply400CorpIdentifyRequest) {
	request = &Apply400CorpIdentifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "Apply400CorpIdentify", "", "")
	request.Method = requests.POST
	return
}

// CreateApply400CorpIdentifyResponse creates a response to parse from Apply400CorpIdentify response
func CreateApply400CorpIdentifyResponse() (response *Apply400CorpIdentifyResponse) {
	response = &Apply400CorpIdentifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
