package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVnInstance invokes the cloudcallcenter.DescribeVnInstance API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevninstance.html
func (client *Client) DescribeVnInstance(request *DescribeVnInstanceRequest) (response *DescribeVnInstanceResponse, err error) {
	response = CreateDescribeVnInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVnInstanceWithChan invokes the cloudcallcenter.DescribeVnInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVnInstanceWithChan(request *DescribeVnInstanceRequest) (<-chan *DescribeVnInstanceResponse, <-chan error) {
	responseChan := make(chan *DescribeVnInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVnInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVnInstanceWithCallback invokes the cloudcallcenter.DescribeVnInstance API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevninstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVnInstanceWithCallback(request *DescribeVnInstanceRequest, callback func(response *DescribeVnInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVnInstanceResponse
		var err error
		defer close(result)
		response, err = client.DescribeVnInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVnInstanceRequest is the request struct for api DescribeVnInstance
type DescribeVnInstanceRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DescribeVnInstanceResponse is the response struct for api DescribeVnInstance
type DescribeVnInstanceResponse struct {
	*responses.BaseResponse
	RequestId            string   `json:"RequestId" xml:"RequestId"`
	InstanceId           string   `json:"InstanceId" xml:"InstanceId"`
	Name                 string   `json:"Name" xml:"Name"`
	Description          string   `json:"Description" xml:"Description"`
	Status               string   `json:"Status" xml:"Status"`
	Concurrency          int64    `json:"Concurrency" xml:"Concurrency"`
	ModifyTime           int64    `json:"ModifyTime" xml:"ModifyTime"`
	ModifyUserName       string   `json:"ModifyUserName" xml:"ModifyUserName"`
	NluServiceType       string   `json:"NluServiceType" xml:"NluServiceType"`
	ApplicableOperations []string `json:"ApplicableOperations" xml:"ApplicableOperations"`
}

// CreateDescribeVnInstanceRequest creates a request to invoke DescribeVnInstance API
func CreateDescribeVnInstanceRequest() (request *DescribeVnInstanceRequest) {
	request = &DescribeVnInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DescribeVnInstance", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeVnInstanceResponse creates a response to parse from DescribeVnInstance response
func CreateDescribeVnInstanceResponse() (response *DescribeVnInstanceResponse) {
	response = &DescribeVnInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
