package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetApDetailedConfig invokes the cloudwf.GetApDetailedConfig API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getapdetailedconfig.html
func (client *Client) GetApDetailedConfig(request *GetApDetailedConfigRequest) (response *GetApDetailedConfigResponse, err error) {
	response = CreateGetApDetailedConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetApDetailedConfigWithChan invokes the cloudwf.GetApDetailedConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getapdetailedconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetApDetailedConfigWithChan(request *GetApDetailedConfigRequest) (<-chan *GetApDetailedConfigResponse, <-chan error) {
	responseChan := make(chan *GetApDetailedConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetApDetailedConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetApDetailedConfigWithCallback invokes the cloudwf.GetApDetailedConfig API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getapdetailedconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetApDetailedConfigWithCallback(request *GetApDetailedConfigRequest, callback func(response *GetApDetailedConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetApDetailedConfigResponse
		var err error
		defer close(result)
		response, err = client.GetApDetailedConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetApDetailedConfigRequest is the request struct for api GetApDetailedConfig
type GetApDetailedConfigRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Query" name:"Id"`
}

// GetApDetailedConfigResponse is the response struct for api GetApDetailedConfig
type GetApDetailedConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetApDetailedConfigRequest creates a request to invoke GetApDetailedConfig API
func CreateGetApDetailedConfigRequest() (request *GetApDetailedConfigRequest) {
	request = &GetApDetailedConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetApDetailedConfig", "cloudwf", "openAPI")
	return
}

// CreateGetApDetailedConfigResponse creates a response to parse from GetApDetailedConfig response
func CreateGetApDetailedConfigResponse() (response *GetApDetailedConfigResponse) {
	response = &GetApDetailedConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
