package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableDasPro invokes the das.DisableDasPro API synchronously
func (client *Client) DisableDasPro(request *DisableDasProRequest) (response *DisableDasProResponse, err error) {
	response = CreateDisableDasProResponse()
	err = client.DoAction(request, response)
	return
}

// DisableDasProWithChan invokes the das.DisableDasPro API asynchronously
func (client *Client) DisableDasProWithChan(request *DisableDasProRequest) (<-chan *DisableDasProResponse, <-chan error) {
	responseChan := make(chan *DisableDasProResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableDasPro(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableDasProWithCallback invokes the das.DisableDasPro API asynchronously
func (client *Client) DisableDasProWithCallback(request *DisableDasProRequest, callback func(response *DisableDasProResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableDasProResponse
		var err error
		defer close(result)
		response, err = client.DisableDasPro(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableDasProRequest is the request struct for api DisableDasPro
type DisableDasProRequest struct {
	*requests.RpcRequest
	UserId     string `position:"Query" name:"UserId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DisableDasProResponse is the response struct for api DisableDasPro
type DisableDasProResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Synchro   string `json:"Synchro" xml:"Synchro"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateDisableDasProRequest creates a request to invoke DisableDasPro API
func CreateDisableDasProRequest() (request *DisableDasProRequest) {
	request = &DisableDasProRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "DisableDasPro", "", "")
	request.Method = requests.POST
	return
}

// CreateDisableDasProResponse creates a response to parse from DisableDasPro response
func CreateDisableDasProResponse() (response *DisableDasProResponse) {
	response = &DisableDasProResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
