package eas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteServiceAutoScaler invokes the eas.DeleteServiceAutoScaler API synchronously
func (client *Client) DeleteServiceAutoScaler(request *DeleteServiceAutoScalerRequest) (response *DeleteServiceAutoScalerResponse, err error) {
	response = CreateDeleteServiceAutoScalerResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteServiceAutoScalerWithChan invokes the eas.DeleteServiceAutoScaler API asynchronously
func (client *Client) DeleteServiceAutoScalerWithChan(request *DeleteServiceAutoScalerRequest) (<-chan *DeleteServiceAutoScalerResponse, <-chan error) {
	responseChan := make(chan *DeleteServiceAutoScalerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteServiceAutoScaler(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteServiceAutoScalerWithCallback invokes the eas.DeleteServiceAutoScaler API asynchronously
func (client *Client) DeleteServiceAutoScalerWithCallback(request *DeleteServiceAutoScalerRequest, callback func(response *DeleteServiceAutoScalerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteServiceAutoScalerResponse
		var err error
		defer close(result)
		response, err = client.DeleteServiceAutoScaler(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteServiceAutoScalerRequest is the request struct for api DeleteServiceAutoScaler
type DeleteServiceAutoScalerRequest struct {
	*requests.RoaRequest
	ServiceName string `position:"Path" name:"ServiceName"`
	ClusterId   string `position:"Path" name:"ClusterId"`
}

// DeleteServiceAutoScalerResponse is the response struct for api DeleteServiceAutoScaler
type DeleteServiceAutoScalerResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteServiceAutoScalerRequest creates a request to invoke DeleteServiceAutoScaler API
func CreateDeleteServiceAutoScalerRequest() (request *DeleteServiceAutoScalerRequest) {
	request = &DeleteServiceAutoScalerRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("eas", "2021-07-01", "DeleteServiceAutoScaler", "/api/v2/services/[ClusterId]/[ServiceName]/autoscaler", "eas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteServiceAutoScalerResponse creates a response to parse from DeleteServiceAutoScaler response
func CreateDeleteServiceAutoScalerResponse() (response *DeleteServiceAutoScalerResponse) {
	response = &DeleteServiceAutoScalerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
