package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeElasticsearchHealth invokes the elasticsearch.DescribeElasticsearchHealth API synchronously
func (client *Client) DescribeElasticsearchHealth(request *DescribeElasticsearchHealthRequest) (response *DescribeElasticsearchHealthResponse, err error) {
	response = CreateDescribeElasticsearchHealthResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeElasticsearchHealthWithChan invokes the elasticsearch.DescribeElasticsearchHealth API asynchronously
func (client *Client) DescribeElasticsearchHealthWithChan(request *DescribeElasticsearchHealthRequest) (<-chan *DescribeElasticsearchHealthResponse, <-chan error) {
	responseChan := make(chan *DescribeElasticsearchHealthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeElasticsearchHealth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeElasticsearchHealthWithCallback invokes the elasticsearch.DescribeElasticsearchHealth API asynchronously
func (client *Client) DescribeElasticsearchHealthWithCallback(request *DescribeElasticsearchHealthRequest, callback func(response *DescribeElasticsearchHealthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeElasticsearchHealthResponse
		var err error
		defer close(result)
		response, err = client.DescribeElasticsearchHealth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeElasticsearchHealthRequest is the request struct for api DescribeElasticsearchHealth
type DescribeElasticsearchHealthRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// DescribeElasticsearchHealthResponse is the response struct for api DescribeElasticsearchHealth
type DescribeElasticsearchHealthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateDescribeElasticsearchHealthRequest creates a request to invoke DescribeElasticsearchHealth API
func CreateDescribeElasticsearchHealthRequest() (request *DescribeElasticsearchHealthRequest) {
	request = &DescribeElasticsearchHealthRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DescribeElasticsearchHealth", "/openapi/instances/[InstanceId]/elasticsearch-health", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeElasticsearchHealthResponse creates a response to parse from DescribeElasticsearchHealth response
func CreateDescribeElasticsearchHealthResponse() (response *DescribeElasticsearchHealthResponse) {
	response = &DescribeElasticsearchHealthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
