package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteResourceQueue invokes the emr.DeleteResourceQueue API synchronously
func (client *Client) DeleteResourceQueue(request *DeleteResourceQueueRequest) (response *DeleteResourceQueueResponse, err error) {
	response = CreateDeleteResourceQueueResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteResourceQueueWithChan invokes the emr.DeleteResourceQueue API asynchronously
func (client *Client) DeleteResourceQueueWithChan(request *DeleteResourceQueueRequest) (<-chan *DeleteResourceQueueResponse, <-chan error) {
	responseChan := make(chan *DeleteResourceQueueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteResourceQueue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteResourceQueueWithCallback invokes the emr.DeleteResourceQueue API asynchronously
func (client *Client) DeleteResourceQueueWithCallback(request *DeleteResourceQueueRequest, callback func(response *DeleteResourceQueueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteResourceQueueResponse
		var err error
		defer close(result)
		response, err = client.DeleteResourceQueue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteResourceQueueRequest is the request struct for api DeleteResourceQueue
type DeleteResourceQueueRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	ResourceQueueId string           `position:"Query" name:"ResourceQueueId"`
}

// DeleteResourceQueueResponse is the response struct for api DeleteResourceQueue
type DeleteResourceQueueResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteResourceQueueRequest creates a request to invoke DeleteResourceQueue API
func CreateDeleteResourceQueueRequest() (request *DeleteResourceQueueRequest) {
	request = &DeleteResourceQueueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteResourceQueue", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteResourceQueueResponse creates a response to parse from DeleteResourceQueue response
func CreateDeleteResourceQueueResponse() (response *DeleteResourceQueueResponse) {
	response = &DeleteResourceQueueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
