package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNetworks invokes the ens.DescribeNetworks API synchronously
func (client *Client) DescribeNetworks(request *DescribeNetworksRequest) (response *DescribeNetworksResponse, err error) {
	response = CreateDescribeNetworksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNetworksWithChan invokes the ens.DescribeNetworks API asynchronously
func (client *Client) DescribeNetworksWithChan(request *DescribeNetworksRequest) (<-chan *DescribeNetworksResponse, <-chan error) {
	responseChan := make(chan *DescribeNetworksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNetworks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNetworksWithCallback invokes the ens.DescribeNetworks API asynchronously
func (client *Client) DescribeNetworksWithCallback(request *DescribeNetworksRequest, callback func(response *DescribeNetworksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNetworksResponse
		var err error
		defer close(result)
		response, err = client.DescribeNetworks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNetworksRequest is the request struct for api DescribeNetworks
type DescribeNetworksRequest struct {
	*requests.RpcRequest
	PageNumber  requests.Integer `position:"Query" name:"PageNumber"`
	EnsRegionId string           `position:"Query" name:"EnsRegionId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	NetworkName string           `position:"Query" name:"NetworkName"`
	NetworkId   string           `position:"Query" name:"NetworkId"`
}

// DescribeNetworksResponse is the response struct for api DescribeNetworks
type DescribeNetworksResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	TotalCount int      `json:"TotalCount" xml:"TotalCount"`
	PageSize   int      `json:"PageSize" xml:"PageSize"`
	PageNumber int      `json:"PageNumber" xml:"PageNumber"`
	Networks   Networks `json:"Networks" xml:"Networks"`
}

// CreateDescribeNetworksRequest creates a request to invoke DescribeNetworks API
func CreateDescribeNetworksRequest() (request *DescribeNetworksRequest) {
	request = &DescribeNetworksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeNetworks", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeNetworksResponse creates a response to parse from DescribeNetworks response
func CreateDescribeNetworksResponse() (response *DescribeNetworksResponse) {
	response = &DescribeNetworksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
