package ess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableScalingGroup invokes the ess.EnableScalingGroup API synchronously
func (client *Client) EnableScalingGroup(request *EnableScalingGroupRequest) (response *EnableScalingGroupResponse, err error) {
	response = CreateEnableScalingGroupResponse()
	err = client.DoAction(request, response)
	return
}

// EnableScalingGroupWithChan invokes the ess.EnableScalingGroup API asynchronously
func (client *Client) EnableScalingGroupWithChan(request *EnableScalingGroupRequest) (<-chan *EnableScalingGroupResponse, <-chan error) {
	responseChan := make(chan *EnableScalingGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableScalingGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableScalingGroupWithCallback invokes the ess.EnableScalingGroup API asynchronously
func (client *Client) EnableScalingGroupWithCallback(request *EnableScalingGroupRequest, callback func(response *EnableScalingGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableScalingGroupResponse
		var err error
		defer close(result)
		response, err = client.EnableScalingGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableScalingGroupRequest is the request struct for api EnableScalingGroup
type EnableScalingGroupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId              requests.Integer                            `position:"Query" name:"ResourceOwnerId"`
	ScalingGroupId               string                                      `position:"Query" name:"ScalingGroupId"`
	ActiveScalingConfigurationId string                                      `position:"Query" name:"ActiveScalingConfigurationId"`
	LaunchTemplateId             string                                      `position:"Query" name:"LaunchTemplateId"`
	ResourceOwnerAccount         string                                      `position:"Query" name:"ResourceOwnerAccount"`
	LaunchTemplateOverride       *[]EnableScalingGroupLaunchTemplateOverride `position:"Query" name:"LaunchTemplateOverride"  type:"Repeated"`
	OwnerAccount                 string                                      `position:"Query" name:"OwnerAccount"`
	OwnerId                      requests.Integer                            `position:"Query" name:"OwnerId"`
	LaunchTemplateVersion        string                                      `position:"Query" name:"LaunchTemplateVersion"`
	InstanceId                   *[]string                                   `position:"Query" name:"InstanceId"  type:"Repeated"`
	LoadBalancerWeight           *[]string                                   `position:"Query" name:"LoadBalancerWeight"  type:"Repeated"`
}

// EnableScalingGroupLaunchTemplateOverride is a repeated param struct in EnableScalingGroupRequest
type EnableScalingGroupLaunchTemplateOverride struct {
	WeightedCapacity string `name:"WeightedCapacity"`
	InstanceType     string `name:"InstanceType"`
}

// EnableScalingGroupResponse is the response struct for api EnableScalingGroup
type EnableScalingGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableScalingGroupRequest creates a request to invoke EnableScalingGroup API
func CreateEnableScalingGroupRequest() (request *EnableScalingGroupRequest) {
	request = &EnableScalingGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ess", "2014-08-28", "EnableScalingGroup", "ess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableScalingGroupResponse creates a response to parse from EnableScalingGroup response
func CreateEnableScalingGroupResponse() (response *EnableScalingGroupResponse) {
	response = &EnableScalingGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
