package ft

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FtDynamicAddressDubbo invokes the ft.FtDynamicAddressDubbo API synchronously
func (client *Client) FtDynamicAddressDubbo(request *FtDynamicAddressDubboRequest) (response *FtDynamicAddressDubboResponse, err error) {
	response = CreateFtDynamicAddressDubboResponse()
	err = client.DoAction(request, response)
	return
}

// FtDynamicAddressDubboWithChan invokes the ft.FtDynamicAddressDubbo API asynchronously
func (client *Client) FtDynamicAddressDubboWithChan(request *FtDynamicAddressDubboRequest) (<-chan *FtDynamicAddressDubboResponse, <-chan error) {
	responseChan := make(chan *FtDynamicAddressDubboResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FtDynamicAddressDubbo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FtDynamicAddressDubboWithCallback invokes the ft.FtDynamicAddressDubbo API asynchronously
func (client *Client) FtDynamicAddressDubboWithCallback(request *FtDynamicAddressDubboRequest, callback func(response *FtDynamicAddressDubboResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FtDynamicAddressDubboResponse
		var err error
		defer close(result)
		response, err = client.FtDynamicAddressDubbo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FtDynamicAddressDubboRequest is the request struct for api FtDynamicAddressDubbo
type FtDynamicAddressDubboRequest struct {
	*requests.RpcRequest
	IntValue    requests.Integer `position:"Query" name:"IntValue"`
	StringValue string           `position:"Query" name:"StringValue"`
}

// FtDynamicAddressDubboResponse is the response struct for api FtDynamicAddressDubbo
type FtDynamicAddressDubboResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	StringValue string `json:"StringValue" xml:"StringValue"`
	IntValue    int    `json:"IntValue" xml:"IntValue"`
}

// CreateFtDynamicAddressDubboRequest creates a request to invoke FtDynamicAddressDubbo API
func CreateFtDynamicAddressDubboRequest() (request *FtDynamicAddressDubboRequest) {
	request = &FtDynamicAddressDubboRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ft", "2018-07-13", "FtDynamicAddressDubbo", "", "")
	request.Method = requests.POST
	return
}

// CreateFtDynamicAddressDubboResponse creates a response to parse from FtDynamicAddressDubbo response
func CreateFtDynamicAddressDubboResponse() (response *FtDynamicAddressDubboResponse) {
	response = &FtDynamicAddressDubboResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
