package hbase

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRestoreSchemaDetails invokes the hbase.DescribeRestoreSchemaDetails API synchronously
func (client *Client) DescribeRestoreSchemaDetails(request *DescribeRestoreSchemaDetailsRequest) (response *DescribeRestoreSchemaDetailsResponse, err error) {
	response = CreateDescribeRestoreSchemaDetailsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRestoreSchemaDetailsWithChan invokes the hbase.DescribeRestoreSchemaDetails API asynchronously
func (client *Client) DescribeRestoreSchemaDetailsWithChan(request *DescribeRestoreSchemaDetailsRequest) (<-chan *DescribeRestoreSchemaDetailsResponse, <-chan error) {
	responseChan := make(chan *DescribeRestoreSchemaDetailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRestoreSchemaDetails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRestoreSchemaDetailsWithCallback invokes the hbase.DescribeRestoreSchemaDetails API asynchronously
func (client *Client) DescribeRestoreSchemaDetailsWithCallback(request *DescribeRestoreSchemaDetailsRequest, callback func(response *DescribeRestoreSchemaDetailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRestoreSchemaDetailsResponse
		var err error
		defer close(result)
		response, err = client.DescribeRestoreSchemaDetails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRestoreSchemaDetailsRequest is the request struct for api DescribeRestoreSchemaDetails
type DescribeRestoreSchemaDetailsRequest struct {
	*requests.RpcRequest
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	RestoreRecordId string           `position:"Query" name:"RestoreRecordId"`
}

// DescribeRestoreSchemaDetailsResponse is the response struct for api DescribeRestoreSchemaDetails
type DescribeRestoreSchemaDetailsResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	RestoreSchema RestoreSchema `json:"RestoreSchema" xml:"RestoreSchema"`
}

// CreateDescribeRestoreSchemaDetailsRequest creates a request to invoke DescribeRestoreSchemaDetails API
func CreateDescribeRestoreSchemaDetailsRequest() (request *DescribeRestoreSchemaDetailsRequest) {
	request = &DescribeRestoreSchemaDetailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("HBase", "2019-01-01", "DescribeRestoreSchemaDetails", "hbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeRestoreSchemaDetailsResponse creates a response to parse from DescribeRestoreSchemaDetails response
func CreateDescribeRestoreSchemaDetailsResponse() (response *DescribeRestoreSchemaDetailsResponse) {
	response = &DescribeRestoreSchemaDetailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
