package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetImageCroppingSuggestions invokes the imm.GetImageCroppingSuggestions API synchronously
func (client *Client) GetImageCroppingSuggestions(request *GetImageCroppingSuggestionsRequest) (response *GetImageCroppingSuggestionsResponse, err error) {
	response = CreateGetImageCroppingSuggestionsResponse()
	err = client.DoAction(request, response)
	return
}

// GetImageCroppingSuggestionsWithChan invokes the imm.GetImageCroppingSuggestions API asynchronously
func (client *Client) GetImageCroppingSuggestionsWithChan(request *GetImageCroppingSuggestionsRequest) (<-chan *GetImageCroppingSuggestionsResponse, <-chan error) {
	responseChan := make(chan *GetImageCroppingSuggestionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetImageCroppingSuggestions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetImageCroppingSuggestionsWithCallback invokes the imm.GetImageCroppingSuggestions API asynchronously
func (client *Client) GetImageCroppingSuggestionsWithCallback(request *GetImageCroppingSuggestionsRequest, callback func(response *GetImageCroppingSuggestionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetImageCroppingSuggestionsResponse
		var err error
		defer close(result)
		response, err = client.GetImageCroppingSuggestions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetImageCroppingSuggestionsRequest is the request struct for api GetImageCroppingSuggestions
type GetImageCroppingSuggestionsRequest struct {
	*requests.RpcRequest
	Project      string `position:"Query" name:"Project"`
	AspectRatios string `position:"Query" name:"AspectRatios"`
	ImageUri     string `position:"Query" name:"ImageUri"`
}

// GetImageCroppingSuggestionsResponse is the response struct for api GetImageCroppingSuggestions
type GetImageCroppingSuggestionsResponse struct {
	*responses.BaseResponse
	RequestId           string                    `json:"RequestId" xml:"RequestId"`
	ImageUri            string                    `json:"ImageUri" xml:"ImageUri"`
	CroppingSuggestions []CroppingSuggestionsItem `json:"CroppingSuggestions" xml:"CroppingSuggestions"`
}

// CreateGetImageCroppingSuggestionsRequest creates a request to invoke GetImageCroppingSuggestions API
func CreateGetImageCroppingSuggestionsRequest() (request *GetImageCroppingSuggestionsRequest) {
	request = &GetImageCroppingSuggestionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "GetImageCroppingSuggestions", "imm", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetImageCroppingSuggestionsResponse creates a response to parse from GetImageCroppingSuggestions response
func CreateGetImageCroppingSuggestionsResponse() (response *GetImageCroppingSuggestionsResponse) {
	response = &GetImageCroppingSuggestionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
