package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDeviceSpeech invokes the iot.DeleteDeviceSpeech API synchronously
func (client *Client) DeleteDeviceSpeech(request *DeleteDeviceSpeechRequest) (response *DeleteDeviceSpeechResponse, err error) {
	response = CreateDeleteDeviceSpeechResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDeviceSpeechWithChan invokes the iot.DeleteDeviceSpeech API asynchronously
func (client *Client) DeleteDeviceSpeechWithChan(request *DeleteDeviceSpeechRequest) (<-chan *DeleteDeviceSpeechResponse, <-chan error) {
	responseChan := make(chan *DeleteDeviceSpeechResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDeviceSpeech(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDeviceSpeechWithCallback invokes the iot.DeleteDeviceSpeech API asynchronously
func (client *Client) DeleteDeviceSpeechWithCallback(request *DeleteDeviceSpeechRequest, callback func(response *DeleteDeviceSpeechResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDeviceSpeechResponse
		var err error
		defer close(result)
		response, err = client.DeleteDeviceSpeech(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDeviceSpeechRequest is the request struct for api DeleteDeviceSpeech
type DeleteDeviceSpeechRequest struct {
	*requests.RpcRequest
	IotId            string                                `position:"Body" name:"IotId"`
	IotInstanceId    string                                `position:"Body" name:"IotInstanceId"`
	ApiProduct       string                                `position:"Body" name:"ApiProduct"`
	ApiRevision      string                                `position:"Body" name:"ApiRevision"`
	DeviceSpeechList *[]DeleteDeviceSpeechDeviceSpeechList `position:"Body" name:"DeviceSpeechList"  type:"Repeated"`
}

// DeleteDeviceSpeechDeviceSpeechList is a repeated param struct in DeleteDeviceSpeechRequest
type DeleteDeviceSpeechDeviceSpeechList struct {
	BizCode     string `name:"BizCode"`
	AudioFormat string `name:"AudioFormat"`
}

// DeleteDeviceSpeechResponse is the response struct for api DeleteDeviceSpeech
type DeleteDeviceSpeechResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDeleteDeviceSpeechRequest creates a request to invoke DeleteDeviceSpeech API
func CreateDeleteDeviceSpeechRequest() (request *DeleteDeviceSpeechRequest) {
	request = &DeleteDeviceSpeechRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DeleteDeviceSpeech", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDeviceSpeechResponse creates a response to parse from DeleteDeviceSpeech response
func CreateDeleteDeviceSpeechResponse() (response *DeleteDeviceSpeechResponse) {
	response = &DeleteDeviceSpeechResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
