package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportCertificate invokes the kms.ExportCertificate API synchronously
func (client *Client) ExportCertificate(request *ExportCertificateRequest) (response *ExportCertificateResponse, err error) {
	response = CreateExportCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// ExportCertificateWithChan invokes the kms.ExportCertificate API asynchronously
func (client *Client) ExportCertificateWithChan(request *ExportCertificateRequest) (<-chan *ExportCertificateResponse, <-chan error) {
	responseChan := make(chan *ExportCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportCertificateWithCallback invokes the kms.ExportCertificate API asynchronously
func (client *Client) ExportCertificateWithCallback(request *ExportCertificateRequest, callback func(response *ExportCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportCertificateResponse
		var err error
		defer close(result)
		response, err = client.ExportCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportCertificateRequest is the request struct for api ExportCertificate
type ExportCertificateRequest struct {
	*requests.RpcRequest
	CertificateId string `position:"Query" name:"CertificateId"`
	Passphrase    string `position:"Query" name:"Passphrase"`
	ExportFormat  string `position:"Query" name:"ExportFormat"`
}

// ExportCertificateResponse is the response struct for api ExportCertificate
type ExportCertificateResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	CertificateId    string `json:"CertificateId" xml:"CertificateId"`
	Certificate      string `json:"Certificate" xml:"Certificate"`
	CertificateChain string `json:"CertificateChain" xml:"CertificateChain"`
	PrivateKey       string `json:"PrivateKey" xml:"PrivateKey"`
	PKCS12Blob       string `json:"PKCS12Blob" xml:"PKCS12Blob"`
}

// CreateExportCertificateRequest creates a request to invoke ExportCertificate API
func CreateExportCertificateRequest() (request *ExportCertificateRequest) {
	request = &ExportCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "ExportCertificate", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExportCertificateResponse creates a response to parse from ExportCertificate response
func CreateExportCertificateResponse() (response *ExportCertificateResponse) {
	response = &ExportCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
