package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitVideoPoseJob invokes the mts.SubmitVideoPoseJob API synchronously
func (client *Client) SubmitVideoPoseJob(request *SubmitVideoPoseJobRequest) (response *SubmitVideoPoseJobResponse, err error) {
	response = CreateSubmitVideoPoseJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitVideoPoseJobWithChan invokes the mts.SubmitVideoPoseJob API asynchronously
func (client *Client) SubmitVideoPoseJobWithChan(request *SubmitVideoPoseJobRequest) (<-chan *SubmitVideoPoseJobResponse, <-chan error) {
	responseChan := make(chan *SubmitVideoPoseJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitVideoPoseJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitVideoPoseJobWithCallback invokes the mts.SubmitVideoPoseJob API asynchronously
func (client *Client) SubmitVideoPoseJobWithCallback(request *SubmitVideoPoseJobRequest, callback func(response *SubmitVideoPoseJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitVideoPoseJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitVideoPoseJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitVideoPoseJobRequest is the request struct for api SubmitVideoPoseJob
type SubmitVideoPoseJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OutputConfig         string           `position:"Query" name:"OutputConfig"`
	UserData             string           `position:"Query" name:"UserData"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PipelineId           string           `position:"Query" name:"PipelineId"`
	Input                string           `position:"Query" name:"Input"`
}

// SubmitVideoPoseJobResponse is the response struct for api SubmitVideoPoseJob
type SubmitVideoPoseJobResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	VideoPoseJob VideoPoseJob `json:"VideoPoseJob" xml:"VideoPoseJob"`
}

// CreateSubmitVideoPoseJobRequest creates a request to invoke SubmitVideoPoseJob API
func CreateSubmitVideoPoseJobRequest() (request *SubmitVideoPoseJobRequest) {
	request = &SubmitVideoPoseJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitVideoPoseJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitVideoPoseJobResponse creates a response to parse from SubmitVideoPoseJob response
func CreateSubmitVideoPoseJobResponse() (response *SubmitVideoPoseJobResponse) {
	response = &SubmitVideoPoseJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
