package nlp_automl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddMtIntervenePackage invokes the nlp_automl.AddMtIntervenePackage API synchronously
func (client *Client) AddMtIntervenePackage(request *AddMtIntervenePackageRequest) (response *AddMtIntervenePackageResponse, err error) {
	response = CreateAddMtIntervenePackageResponse()
	err = client.DoAction(request, response)
	return
}

// AddMtIntervenePackageWithChan invokes the nlp_automl.AddMtIntervenePackage API asynchronously
func (client *Client) AddMtIntervenePackageWithChan(request *AddMtIntervenePackageRequest) (<-chan *AddMtIntervenePackageResponse, <-chan error) {
	responseChan := make(chan *AddMtIntervenePackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddMtIntervenePackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddMtIntervenePackageWithCallback invokes the nlp_automl.AddMtIntervenePackage API asynchronously
func (client *Client) AddMtIntervenePackageWithCallback(request *AddMtIntervenePackageRequest, callback func(response *AddMtIntervenePackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddMtIntervenePackageResponse
		var err error
		defer close(result)
		response, err = client.AddMtIntervenePackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddMtIntervenePackageRequest is the request struct for api AddMtIntervenePackage
type AddMtIntervenePackageRequest struct {
	*requests.RpcRequest
	SourceLanguage string           `position:"Query" name:"SourceLanguage"`
	Product        string           `position:"Query" name:"Product"`
	PackageName    string           `position:"Query" name:"PackageName"`
	TenantId       requests.Integer `position:"Query" name:"TenantId"`
	ProjectType    string           `position:"Query" name:"ProjectType"`
	SourceType     string           `position:"Query" name:"SourceType"`
	TargetLanguage string           `position:"Query" name:"TargetLanguage"`
	Category       string           `position:"Query" name:"Category"`
	ProjectId      requests.Integer `position:"Query" name:"ProjectId"`
}

// AddMtIntervenePackageResponse is the response struct for api AddMtIntervenePackage
type AddMtIntervenePackageResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   int    `json:"Message" xml:"Message"`
	PackageId string `json:"PackageId" xml:"PackageId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddMtIntervenePackageRequest creates a request to invoke AddMtIntervenePackage API
func CreateAddMtIntervenePackageRequest() (request *AddMtIntervenePackageRequest) {
	request = &AddMtIntervenePackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nlp-automl", "2019-07-01", "AddMtIntervenePackage", "nlpautoml", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddMtIntervenePackageResponse creates a response to parse from AddMtIntervenePackage response
func CreateAddMtIntervenePackageResponse() (response *AddMtIntervenePackageResponse) {
	response = &AddMtIntervenePackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
