package objectdet

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetectObject invokes the objectdet.DetectObject API synchronously
func (client *Client) DetectObject(request *DetectObjectRequest) (response *DetectObjectResponse, err error) {
	response = CreateDetectObjectResponse()
	err = client.DoAction(request, response)
	return
}

// DetectObjectWithChan invokes the objectdet.DetectObject API asynchronously
func (client *Client) DetectObjectWithChan(request *DetectObjectRequest) (<-chan *DetectObjectResponse, <-chan error) {
	responseChan := make(chan *DetectObjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetectObject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetectObjectWithCallback invokes the objectdet.DetectObject API asynchronously
func (client *Client) DetectObjectWithCallback(request *DetectObjectRequest, callback func(response *DetectObjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetectObjectResponse
		var err error
		defer close(result)
		response, err = client.DetectObject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetectObjectRequest is the request struct for api DetectObject
type DetectObjectRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// DetectObjectResponse is the response struct for api DetectObject
type DetectObjectResponse struct {
	*responses.BaseResponse
	RequestId string             `json:"RequestId" xml:"RequestId"`
	Data      DataInDetectObject `json:"Data" xml:"Data"`
}

// CreateDetectObjectRequest creates a request to invoke DetectObject API
func CreateDetectObjectRequest() (request *DetectObjectRequest) {
	request = &DetectObjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("objectdet", "2019-12-30", "DetectObject", "objectdet", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetectObjectResponse creates a response to parse from DetectObject response
func CreateDetectObjectResponse() (response *DetectObjectResponse) {
	response = &DetectObjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
