package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSecretParameters invokes the oos.ListSecretParameters API synchronously
func (client *Client) ListSecretParameters(request *ListSecretParametersRequest) (response *ListSecretParametersResponse, err error) {
	response = CreateListSecretParametersResponse()
	err = client.DoAction(request, response)
	return
}

// ListSecretParametersWithChan invokes the oos.ListSecretParameters API asynchronously
func (client *Client) ListSecretParametersWithChan(request *ListSecretParametersRequest) (<-chan *ListSecretParametersResponse, <-chan error) {
	responseChan := make(chan *ListSecretParametersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSecretParameters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSecretParametersWithCallback invokes the oos.ListSecretParameters API asynchronously
func (client *Client) ListSecretParametersWithCallback(request *ListSecretParametersRequest, callback func(response *ListSecretParametersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSecretParametersResponse
		var err error
		defer close(result)
		response, err = client.ListSecretParameters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSecretParametersRequest is the request struct for api ListSecretParameters
type ListSecretParametersRequest struct {
	*requests.RpcRequest
	Recursive  requests.Boolean `position:"Query" name:"Recursive"`
	Tags       string           `position:"Query" name:"Tags"`
	Path       string           `position:"Query" name:"Path"`
	NextToken  string           `position:"Query" name:"NextToken"`
	Name       string           `position:"Query" name:"Name"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
	SortOrder  string           `position:"Query" name:"SortOrder"`
	SortField  string           `position:"Query" name:"SortField"`
}

// ListSecretParametersResponse is the response struct for api ListSecretParameters
type ListSecretParametersResponse struct {
	*responses.BaseResponse
	RequestId  string                            `json:"RequestId" xml:"RequestId"`
	MaxResults int                               `json:"MaxResults" xml:"MaxResults"`
	NextToken  string                            `json:"NextToken" xml:"NextToken"`
	Parameters []ParameterInListSecretParameters `json:"Parameters" xml:"Parameters"`
}

// CreateListSecretParametersRequest creates a request to invoke ListSecretParameters API
func CreateListSecretParametersRequest() (request *ListSecretParametersRequest) {
	request = &ListSecretParametersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "ListSecretParameters", "", "")
	request.Method = requests.POST
	return
}

// CreateListSecretParametersResponse creates a response to parse from ListSecretParameters response
func CreateListSecretParametersResponse() (response *ListSecretParametersResponse) {
	response = &ListSecretParametersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
