package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AlterDatabase invokes the openanalytics_open.AlterDatabase API synchronously
func (client *Client) AlterDatabase(request *AlterDatabaseRequest) (response *AlterDatabaseResponse, err error) {
	response = CreateAlterDatabaseResponse()
	err = client.DoAction(request, response)
	return
}

// AlterDatabaseWithChan invokes the openanalytics_open.AlterDatabase API asynchronously
func (client *Client) AlterDatabaseWithChan(request *AlterDatabaseRequest) (<-chan *AlterDatabaseResponse, <-chan error) {
	responseChan := make(chan *AlterDatabaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AlterDatabase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AlterDatabaseWithCallback invokes the openanalytics_open.AlterDatabase API asynchronously
func (client *Client) AlterDatabaseWithCallback(request *AlterDatabaseRequest, callback func(response *AlterDatabaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AlterDatabaseResponse
		var err error
		defer close(result)
		response, err = client.AlterDatabase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AlterDatabaseRequest is the request struct for api AlterDatabase
type AlterDatabaseRequest struct {
	*requests.RpcRequest
	OldDbName   string `position:"Query" name:"OldDbName"`
	Name        string `position:"Query" name:"Name"`
	Description string `position:"Query" name:"Description"`
	LocationUri string `position:"Query" name:"LocationUri"`
	Parameters  string `position:"Query" name:"Parameters"`
}

// AlterDatabaseResponse is the response struct for api AlterDatabase
type AlterDatabaseResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAlterDatabaseRequest creates a request to invoke AlterDatabase API
func CreateAlterDatabaseRequest() (request *AlterDatabaseRequest) {
	request = &AlterDatabaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2020-09-28", "AlterDatabase", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAlterDatabaseResponse creates a response to parse from AlterDatabase response
func CreateAlterDatabaseResponse() (response *AlterDatabaseResponse) {
	response = &AlterDatabaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
