package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSchedulerInstances invokes the outboundbot.ListSchedulerInstances API synchronously
func (client *Client) ListSchedulerInstances(request *ListSchedulerInstancesRequest) (response *ListSchedulerInstancesResponse, err error) {
	response = CreateListSchedulerInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// ListSchedulerInstancesWithChan invokes the outboundbot.ListSchedulerInstances API asynchronously
func (client *Client) ListSchedulerInstancesWithChan(request *ListSchedulerInstancesRequest) (<-chan *ListSchedulerInstancesResponse, <-chan error) {
	responseChan := make(chan *ListSchedulerInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSchedulerInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSchedulerInstancesWithCallback invokes the outboundbot.ListSchedulerInstances API asynchronously
func (client *Client) ListSchedulerInstancesWithCallback(request *ListSchedulerInstancesRequest, callback func(response *ListSchedulerInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSchedulerInstancesResponse
		var err error
		defer close(result)
		response, err = client.ListSchedulerInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSchedulerInstancesRequest is the request struct for api ListSchedulerInstances
type ListSchedulerInstancesRequest struct {
	*requests.RpcRequest
	InstanceOwnerId requests.Integer `position:"Query" name:"InstanceOwnerId"`
}

// ListSchedulerInstancesResponse is the response struct for api ListSchedulerInstances
type ListSchedulerInstancesResponse struct {
	*responses.BaseResponse
	RequestId          string              `json:"RequestId" xml:"RequestId"`
	Success            bool                `json:"Success" xml:"Success"`
	Code               string              `json:"Code" xml:"Code"`
	Message            string              `json:"Message" xml:"Message"`
	HttpStatusCode     int                 `json:"HttpStatusCode" xml:"HttpStatusCode"`
	SchedulerInstances []SchedulerInstance `json:"SchedulerInstances" xml:"SchedulerInstances"`
}

// CreateListSchedulerInstancesRequest creates a request to invoke ListSchedulerInstances API
func CreateListSchedulerInstancesRequest() (request *ListSchedulerInstancesRequest) {
	request = &ListSchedulerInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "ListSchedulerInstances", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSchedulerInstancesResponse creates a response to parse from ListSchedulerInstances response
func CreateListSchedulerInstancesResponse() (response *ListSchedulerInstancesResponse) {
	response = &ListSchedulerInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
