package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachSecurityGroupToVpcEndpoint invokes the privatelink.AttachSecurityGroupToVpcEndpoint API synchronously
func (client *Client) AttachSecurityGroupToVpcEndpoint(request *AttachSecurityGroupToVpcEndpointRequest) (response *AttachSecurityGroupToVpcEndpointResponse, err error) {
	response = CreateAttachSecurityGroupToVpcEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// AttachSecurityGroupToVpcEndpointWithChan invokes the privatelink.AttachSecurityGroupToVpcEndpoint API asynchronously
func (client *Client) AttachSecurityGroupToVpcEndpointWithChan(request *AttachSecurityGroupToVpcEndpointRequest) (<-chan *AttachSecurityGroupToVpcEndpointResponse, <-chan error) {
	responseChan := make(chan *AttachSecurityGroupToVpcEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachSecurityGroupToVpcEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachSecurityGroupToVpcEndpointWithCallback invokes the privatelink.AttachSecurityGroupToVpcEndpoint API asynchronously
func (client *Client) AttachSecurityGroupToVpcEndpointWithCallback(request *AttachSecurityGroupToVpcEndpointRequest, callback func(response *AttachSecurityGroupToVpcEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachSecurityGroupToVpcEndpointResponse
		var err error
		defer close(result)
		response, err = client.AttachSecurityGroupToVpcEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachSecurityGroupToVpcEndpointRequest is the request struct for api AttachSecurityGroupToVpcEndpoint
type AttachSecurityGroupToVpcEndpointRequest struct {
	*requests.RpcRequest
	ClientToken     string           `position:"Query" name:"ClientToken"`
	EndpointId      string           `position:"Query" name:"EndpointId"`
	SecurityGroupId string           `position:"Query" name:"SecurityGroupId"`
	DryRun          requests.Boolean `position:"Query" name:"DryRun"`
}

// AttachSecurityGroupToVpcEndpointResponse is the response struct for api AttachSecurityGroupToVpcEndpoint
type AttachSecurityGroupToVpcEndpointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAttachSecurityGroupToVpcEndpointRequest creates a request to invoke AttachSecurityGroupToVpcEndpoint API
func CreateAttachSecurityGroupToVpcEndpointRequest() (request *AttachSecurityGroupToVpcEndpointRequest) {
	request = &AttachSecurityGroupToVpcEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "AttachSecurityGroupToVpcEndpoint", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachSecurityGroupToVpcEndpointResponse creates a response to parse from AttachSecurityGroupToVpcEndpoint response
func CreateAttachSecurityGroupToVpcEndpointResponse() (response *AttachSecurityGroupToVpcEndpointResponse) {
	response = &AttachSecurityGroupToVpcEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
