package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListQuotaAlarms invokes the quotas.ListQuotaAlarms API synchronously
func (client *Client) ListQuotaAlarms(request *ListQuotaAlarmsRequest) (response *ListQuotaAlarmsResponse, err error) {
	response = CreateListQuotaAlarmsResponse()
	err = client.DoAction(request, response)
	return
}

// ListQuotaAlarmsWithChan invokes the quotas.ListQuotaAlarms API asynchronously
func (client *Client) ListQuotaAlarmsWithChan(request *ListQuotaAlarmsRequest) (<-chan *ListQuotaAlarmsResponse, <-chan error) {
	responseChan := make(chan *ListQuotaAlarmsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListQuotaAlarms(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListQuotaAlarmsWithCallback invokes the quotas.ListQuotaAlarms API asynchronously
func (client *Client) ListQuotaAlarmsWithCallback(request *ListQuotaAlarmsRequest, callback func(response *ListQuotaAlarmsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListQuotaAlarmsResponse
		var err error
		defer close(result)
		response, err = client.ListQuotaAlarms(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListQuotaAlarmsRequest is the request struct for api ListQuotaAlarms
type ListQuotaAlarmsRequest struct {
	*requests.RpcRequest
	ProductCode     string                            `position:"Body" name:"ProductCode"`
	QuotaActionCode string                            `position:"Body" name:"QuotaActionCode"`
	NextToken       string                            `position:"Body" name:"NextToken"`
	QuotaDimensions *[]ListQuotaAlarmsQuotaDimensions `position:"Body" name:"QuotaDimensions"  type:"Repeated"`
	MaxResults      requests.Integer                  `position:"Body" name:"MaxResults"`
	AlarmName       string                            `position:"Body" name:"AlarmName"`
}

// ListQuotaAlarmsQuotaDimensions is a repeated param struct in ListQuotaAlarmsRequest
type ListQuotaAlarmsQuotaDimensions struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ListQuotaAlarmsResponse is the response struct for api ListQuotaAlarms
type ListQuotaAlarmsResponse struct {
	*responses.BaseResponse
	TotalCount  int          `json:"TotalCount" xml:"TotalCount"`
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	NextToken   string       `json:"NextToken" xml:"NextToken"`
	MaxResults  int          `json:"MaxResults" xml:"MaxResults"`
	QuotaAlarms []QuotaAlarm `json:"QuotaAlarms" xml:"QuotaAlarms"`
}

// CreateListQuotaAlarmsRequest creates a request to invoke ListQuotaAlarms API
func CreateListQuotaAlarmsRequest() (request *ListQuotaAlarmsRequest) {
	request = &ListQuotaAlarmsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "ListQuotaAlarms", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListQuotaAlarmsResponse creates a response to parse from ListQuotaAlarms response
func CreateListQuotaAlarmsResponse() (response *ListQuotaAlarmsResponse) {
	response = &ListQuotaAlarmsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
