package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeGateway invokes the sgw.UpgradeGateway API synchronously
func (client *Client) UpgradeGateway(request *UpgradeGatewayRequest) (response *UpgradeGatewayResponse, err error) {
	response = CreateUpgradeGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeGatewayWithChan invokes the sgw.UpgradeGateway API asynchronously
func (client *Client) UpgradeGatewayWithChan(request *UpgradeGatewayRequest) (<-chan *UpgradeGatewayResponse, <-chan error) {
	responseChan := make(chan *UpgradeGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeGatewayWithCallback invokes the sgw.UpgradeGateway API asynchronously
func (client *Client) UpgradeGatewayWithCallback(request *UpgradeGatewayRequest, callback func(response *UpgradeGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeGatewayResponse
		var err error
		defer close(result)
		response, err = client.UpgradeGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeGatewayRequest is the request struct for api UpgradeGateway
type UpgradeGatewayRequest struct {
	*requests.RpcRequest
	GatewayId string `position:"Query" name:"GatewayId"`
}

// UpgradeGatewayResponse is the response struct for api UpgradeGateway
type UpgradeGatewayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateUpgradeGatewayRequest creates a request to invoke UpgradeGateway API
func CreateUpgradeGatewayRequest() (request *UpgradeGatewayRequest) {
	request = &UpgradeGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "UpgradeGateway", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpgradeGatewayResponse creates a response to parse from UpgradeGateway response
func CreateUpgradeGatewayResponse() (response *UpgradeGatewayResponse) {
	response = &UpgradeGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
