package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TagVodResources invokes the vod.TagVodResources API synchronously
func (client *Client) TagVodResources(request *TagVodResourcesRequest) (response *TagVodResourcesResponse, err error) {
	response = CreateTagVodResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// TagVodResourcesWithChan invokes the vod.TagVodResources API asynchronously
func (client *Client) TagVodResourcesWithChan(request *TagVodResourcesRequest) (<-chan *TagVodResourcesResponse, <-chan error) {
	responseChan := make(chan *TagVodResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TagVodResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TagVodResourcesWithCallback invokes the vod.TagVodResources API asynchronously
func (client *Client) TagVodResourcesWithCallback(request *TagVodResourcesRequest, callback func(response *TagVodResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TagVodResourcesResponse
		var err error
		defer close(result)
		response, err = client.TagVodResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TagVodResourcesRequest is the request struct for api TagVodResources
type TagVodResourcesRequest struct {
	*requests.RpcRequest
	Tag          *[]TagVodResourcesTag `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceId   *[]string             `position:"Query" name:"ResourceId"  type:"Repeated"`
	OwnerId      requests.Integer      `position:"Query" name:"OwnerId"`
	ResourceType string                `position:"Query" name:"ResourceType"`
}

// TagVodResourcesTag is a repeated param struct in TagVodResourcesRequest
type TagVodResourcesTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// TagVodResourcesResponse is the response struct for api TagVodResources
type TagVodResourcesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateTagVodResourcesRequest creates a request to invoke TagVodResources API
func CreateTagVodResourcesRequest() (request *TagVodResourcesRequest) {
	request = &TagVodResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "TagVodResources", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateTagVodResourcesResponse creates a response to parse from TagVodResources response
func CreateTagVodResourcesResponse() (response *TagVodResourcesResponse) {
	response = &TagVodResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
