package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssociateNetworkAcl invokes the vpc.AssociateNetworkAcl API synchronously
func (client *Client) AssociateNetworkAcl(request *AssociateNetworkAclRequest) (response *AssociateNetworkAclResponse, err error) {
	response = CreateAssociateNetworkAclResponse()
	err = client.DoAction(request, response)
	return
}

// AssociateNetworkAclWithChan invokes the vpc.AssociateNetworkAcl API asynchronously
func (client *Client) AssociateNetworkAclWithChan(request *AssociateNetworkAclRequest) (<-chan *AssociateNetworkAclResponse, <-chan error) {
	responseChan := make(chan *AssociateNetworkAclResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssociateNetworkAcl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssociateNetworkAclWithCallback invokes the vpc.AssociateNetworkAcl API asynchronously
func (client *Client) AssociateNetworkAclWithCallback(request *AssociateNetworkAclRequest, callback func(response *AssociateNetworkAclResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssociateNetworkAclResponse
		var err error
		defer close(result)
		response, err = client.AssociateNetworkAcl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssociateNetworkAclRequest is the request struct for api AssociateNetworkAcl
type AssociateNetworkAclRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer               `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string                         `position:"Query" name:"ClientToken"`
	NetworkAclId         string                         `position:"Query" name:"NetworkAclId"`
	Resource             *[]AssociateNetworkAclResource `position:"Query" name:"Resource"  type:"Repeated"`
	ResourceOwnerAccount string                         `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer               `position:"Query" name:"OwnerId"`
}

// AssociateNetworkAclResource is a repeated param struct in AssociateNetworkAclRequest
type AssociateNetworkAclResource struct {
	ResourceType string `name:"ResourceType"`
	ResourceId   string `name:"ResourceId"`
}

// AssociateNetworkAclResponse is the response struct for api AssociateNetworkAcl
type AssociateNetworkAclResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAssociateNetworkAclRequest creates a request to invoke AssociateNetworkAcl API
func CreateAssociateNetworkAclRequest() (request *AssociateNetworkAclRequest) {
	request = &AssociateNetworkAclRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "AssociateNetworkAcl", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAssociateNetworkAclResponse creates a response to parse from AssociateNetworkAcl response
func CreateAssociateNetworkAclResponse() (response *AssociateNetworkAclResponse) {
	response = &AssociateNetworkAclResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
