package workorder

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMqConsumerTag invokes the workorder.GetMqConsumerTag API synchronously
func (client *Client) GetMqConsumerTag(request *GetMqConsumerTagRequest) (response *GetMqConsumerTagResponse, err error) {
	response = CreateGetMqConsumerTagResponse()
	err = client.DoAction(request, response)
	return
}

// GetMqConsumerTagWithChan invokes the workorder.GetMqConsumerTag API asynchronously
func (client *Client) GetMqConsumerTagWithChan(request *GetMqConsumerTagRequest) (<-chan *GetMqConsumerTagResponse, <-chan error) {
	responseChan := make(chan *GetMqConsumerTagResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMqConsumerTag(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMqConsumerTagWithCallback invokes the workorder.GetMqConsumerTag API asynchronously
func (client *Client) GetMqConsumerTagWithCallback(request *GetMqConsumerTagRequest, callback func(response *GetMqConsumerTagResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMqConsumerTagResponse
		var err error
		defer close(result)
		response, err = client.GetMqConsumerTag(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMqConsumerTagRequest is the request struct for api GetMqConsumerTag
type GetMqConsumerTagRequest struct {
	*requests.RpcRequest
}

// GetMqConsumerTagResponse is the response struct for api GetMqConsumerTag
type GetMqConsumerTagResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateGetMqConsumerTagRequest creates a request to invoke GetMqConsumerTag API
func CreateGetMqConsumerTagRequest() (request *GetMqConsumerTagRequest) {
	request = &GetMqConsumerTagRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Workorder", "2021-06-10", "GetMqConsumerTag", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMqConsumerTagResponse creates a response to parse from GetMqConsumerTag response
func CreateGetMqConsumerTagResponse() (response *GetMqConsumerTagResponse) {
	response = &GetMqConsumerTagResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
