package postgresqlflexibleserversapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/postgresql/mgmt/2021-06-01/postgresqlflexibleservers"
)

// ServersClientAPI contains the set of methods on the ServersClient type.
type ServersClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, serverName string, parameters postgresqlflexibleservers.Server) (result postgresqlflexibleservers.ServersCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string) (result postgresqlflexibleservers.ServersDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string) (result postgresqlflexibleservers.Server, err error)
	List(ctx context.Context) (result postgresqlflexibleservers.ServerListResultPage, err error)
	ListComplete(ctx context.Context) (result postgresqlflexibleservers.ServerListResultIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result postgresqlflexibleservers.ServerListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result postgresqlflexibleservers.ServerListResultIterator, err error)
	Restart(ctx context.Context, resourceGroupName string, serverName string, parameters *postgresqlflexibleservers.RestartParameter) (result postgresqlflexibleservers.ServersRestartFuture, err error)
	Start(ctx context.Context, resourceGroupName string, serverName string) (result postgresqlflexibleservers.ServersStartFuture, err error)
	Stop(ctx context.Context, resourceGroupName string, serverName string) (result postgresqlflexibleservers.ServersStopFuture, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, parameters postgresqlflexibleservers.ServerForUpdate) (result postgresqlflexibleservers.ServersUpdateFuture, err error)
}

var _ ServersClientAPI = (*postgresqlflexibleservers.ServersClient)(nil)

// FirewallRulesClientAPI contains the set of methods on the FirewallRulesClient type.
type FirewallRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string, parameters postgresqlflexibleservers.FirewallRule) (result postgresqlflexibleservers.FirewallRulesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string) (result postgresqlflexibleservers.FirewallRulesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string) (result postgresqlflexibleservers.FirewallRule, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result postgresqlflexibleservers.FirewallRuleListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result postgresqlflexibleservers.FirewallRuleListResultIterator, err error)
}

var _ FirewallRulesClientAPI = (*postgresqlflexibleservers.FirewallRulesClient)(nil)

// ConfigurationsClientAPI contains the set of methods on the ConfigurationsClient type.
type ConfigurationsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, configurationName string) (result postgresqlflexibleservers.Configuration, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result postgresqlflexibleservers.ConfigurationListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result postgresqlflexibleservers.ConfigurationListResultIterator, err error)
	Put(ctx context.Context, resourceGroupName string, serverName string, configurationName string, parameters postgresqlflexibleservers.Configuration) (result postgresqlflexibleservers.ConfigurationsPutFuture, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, configurationName string, parameters postgresqlflexibleservers.Configuration) (result postgresqlflexibleservers.ConfigurationsUpdateFuture, err error)
}

var _ ConfigurationsClientAPI = (*postgresqlflexibleservers.ConfigurationsClient)(nil)

// CheckNameAvailabilityClientAPI contains the set of methods on the CheckNameAvailabilityClient type.
type CheckNameAvailabilityClientAPI interface {
	Execute(ctx context.Context, nameAvailabilityRequest postgresqlflexibleservers.NameAvailabilityRequest) (result postgresqlflexibleservers.NameAvailability, err error)
}

var _ CheckNameAvailabilityClientAPI = (*postgresqlflexibleservers.CheckNameAvailabilityClient)(nil)

// LocationBasedCapabilitiesClientAPI contains the set of methods on the LocationBasedCapabilitiesClient type.
type LocationBasedCapabilitiesClientAPI interface {
	Execute(ctx context.Context, locationName string) (result postgresqlflexibleservers.CapabilitiesListResultPage, err error)
	ExecuteComplete(ctx context.Context, locationName string) (result postgresqlflexibleservers.CapabilitiesListResultIterator, err error)
}

var _ LocationBasedCapabilitiesClientAPI = (*postgresqlflexibleservers.LocationBasedCapabilitiesClient)(nil)

// VirtualNetworkSubnetUsageClientAPI contains the set of methods on the VirtualNetworkSubnetUsageClient type.
type VirtualNetworkSubnetUsageClientAPI interface {
	Execute(ctx context.Context, locationName string, parameters postgresqlflexibleservers.VirtualNetworkSubnetUsageParameter) (result postgresqlflexibleservers.VirtualNetworkSubnetUsageResult, err error)
}

var _ VirtualNetworkSubnetUsageClientAPI = (*postgresqlflexibleservers.VirtualNetworkSubnetUsageClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result postgresqlflexibleservers.OperationListResult, err error)
}

var _ OperationsClientAPI = (*postgresqlflexibleservers.OperationsClient)(nil)

// DatabasesClientAPI contains the set of methods on the DatabasesClient type.
type DatabasesClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters postgresqlflexibleservers.Database) (result postgresqlflexibleservers.DatabasesCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result postgresqlflexibleservers.DatabasesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result postgresqlflexibleservers.Database, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result postgresqlflexibleservers.DatabaseListResultPage, err error)
	ListByServerComplete(ctx context.Context, resourceGroupName string, serverName string) (result postgresqlflexibleservers.DatabaseListResultIterator, err error)
}

var _ DatabasesClientAPI = (*postgresqlflexibleservers.DatabasesClient)(nil)

// GetPrivateDNSZoneSuffixClientAPI contains the set of methods on the GetPrivateDNSZoneSuffixClient type.
type GetPrivateDNSZoneSuffixClientAPI interface {
	Execute(ctx context.Context) (result postgresqlflexibleservers.String, err error)
}

var _ GetPrivateDNSZoneSuffixClientAPI = (*postgresqlflexibleservers.GetPrivateDNSZoneSuffixClient)(nil)
