package containerregistry

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/containerregistry/mgmt/2017-06-01-preview/containerregistry"

// Actor the agent that initiated the event. For most situations, this could be from the authorization
// context of the request.
type Actor struct {
	// Name - The subject or username associated with the request context that generated the event.
	Name *string `json:"name,omitempty"`
}

// CallbackConfig the configuration of service URI and custom headers for the webhook.
type CallbackConfig struct {
	autorest.Response `json:"-"`
	// ServiceURI - The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// CustomHeaders - Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders"`
}

// MarshalJSON is the custom marshaler for CallbackConfig.
func (cc CallbackConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if cc.ServiceURI != nil {
		objectMap["serviceUri"] = cc.ServiceURI
	}
	if cc.CustomHeaders != nil {
		objectMap["customHeaders"] = cc.CustomHeaders
	}
	return json.Marshal(objectMap)
}

// Event the event for a webhook.
type Event struct {
	// EventRequestMessage - The event request message sent to the service URI.
	EventRequestMessage *EventRequestMessage `json:"eventRequestMessage,omitempty"`
	// EventResponseMessage - The event response message received from the service URI.
	EventResponseMessage *EventResponseMessage `json:"eventResponseMessage,omitempty"`
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
}

// EventContent the content of the event request message.
type EventContent struct {
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
	// Timestamp - The time at which the event occurred.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Action - The action that encompasses the provided event.
	Action *string `json:"action,omitempty"`
	// Target - The target of the event.
	Target *Target `json:"target,omitempty"`
	// Request - The request that generated the event.
	Request *Request `json:"request,omitempty"`
	// Actor - The agent that initiated the event. For most situations, this could be from the authorization context of the request.
	Actor *Actor `json:"actor,omitempty"`
	// Source - The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.
	Source *Source `json:"source,omitempty"`
}

// EventInfo the basic information of an event.
type EventInfo struct {
	autorest.Response `json:"-"`
	// ID - The event ID.
	ID *string `json:"id,omitempty"`
}

// EventListResult the result of a request to list events for a webhook.
type EventListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of events. Since this list may be incomplete, the nextLink field should be used to request the next list of events.
	Value *[]Event `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of events.
	NextLink *string `json:"nextLink,omitempty"`
}

// EventListResultIterator provides access to a complete listing of Event values.
type EventListResultIterator struct {
	i    int
	page EventListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EventListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EventListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EventListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EventListResultIterator) Response() EventListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EventListResultIterator) Value() Event {
	if !iter.page.NotDone() {
		return Event{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EventListResultIterator type.
func NewEventListResultIterator(page EventListResultPage) EventListResultIterator {
	return EventListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (elr EventListResult) IsEmpty() bool {
	return elr.Value == nil || len(*elr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (elr EventListResult) hasNextLink() bool {
	return elr.NextLink != nil && len(*elr.NextLink) != 0
}

// eventListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (elr EventListResult) eventListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !elr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(elr.NextLink)))
}

// EventListResultPage contains a page of Event values.
type EventListResultPage struct {
	fn  func(context.Context, EventListResult) (EventListResult, error)
	elr EventListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EventListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EventListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.elr)
		if err != nil {
			return err
		}
		page.elr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EventListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EventListResultPage) NotDone() bool {
	return !page.elr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EventListResultPage) Response() EventListResult {
	return page.elr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EventListResultPage) Values() []Event {
	if page.elr.IsEmpty() {
		return nil
	}
	return *page.elr.Value
}

// Creates a new instance of the EventListResultPage type.
func NewEventListResultPage(cur EventListResult, getNextPage func(context.Context, EventListResult) (EventListResult, error)) EventListResultPage {
	return EventListResultPage{
		fn:  getNextPage,
		elr: cur,
	}
}

// EventRequestMessage the event request message sent to the service URI.
type EventRequestMessage struct {
	// Content - The content of the event request message.
	Content *EventContent `json:"content,omitempty"`
	// Headers - The headers of the event request message.
	Headers map[string]*string `json:"headers"`
	// Method - The HTTP method used to send the event request message.
	Method *string `json:"method,omitempty"`
	// RequestURI - The URI used to send the event request message.
	RequestURI *string `json:"requestUri,omitempty"`
	// Version - The HTTP message version.
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for EventRequestMessage.
func (erm EventRequestMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erm.Content != nil {
		objectMap["content"] = erm.Content
	}
	if erm.Headers != nil {
		objectMap["headers"] = erm.Headers
	}
	if erm.Method != nil {
		objectMap["method"] = erm.Method
	}
	if erm.RequestURI != nil {
		objectMap["requestUri"] = erm.RequestURI
	}
	if erm.Version != nil {
		objectMap["version"] = erm.Version
	}
	return json.Marshal(objectMap)
}

// EventResponseMessage the event response message received from the service URI.
type EventResponseMessage struct {
	// Content - The content of the event response message.
	Content *string `json:"content,omitempty"`
	// Headers - The headers of the event response message.
	Headers map[string]*string `json:"headers"`
	// ReasonPhrase - The reason phrase of the event response message.
	ReasonPhrase *string `json:"reasonPhrase,omitempty"`
	// StatusCode - The status code of the event response message.
	StatusCode *string `json:"statusCode,omitempty"`
	// Version - The HTTP message version.
	Version *string `json:"version,omitempty"`
}

// MarshalJSON is the custom marshaler for EventResponseMessage.
func (erm EventResponseMessage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if erm.Content != nil {
		objectMap["content"] = erm.Content
	}
	if erm.Headers != nil {
		objectMap["headers"] = erm.Headers
	}
	if erm.ReasonPhrase != nil {
		objectMap["reasonPhrase"] = erm.ReasonPhrase
	}
	if erm.StatusCode != nil {
		objectMap["statusCode"] = erm.StatusCode
	}
	if erm.Version != nil {
		objectMap["version"] = erm.Version
	}
	return json.Marshal(objectMap)
}

// OperationDefinition the definition of a container registry operation.
type OperationDefinition struct {
	// Name - Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The display information for the container registry operation.
	Display *OperationDisplayDefinition `json:"display,omitempty"`
}

// OperationDisplayDefinition the display information for a container registry operation.
type OperationDisplayDefinition struct {
	// Provider - The resource provider name: Microsoft.ContainerRegistry.
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation that users can perform.
	Operation *string `json:"operation,omitempty"`
	// Description - The description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult the result of a request to list container registry operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container registry operations. Since this list may be incomplete, the nextLink field should be used to request the next list of operations.
	Value *[]OperationDefinition `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of container registry operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of OperationDefinition values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() OperationDefinition {
	if !iter.page.NotDone() {
		return OperationDefinition{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of OperationDefinition values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []OperationDefinition {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// RegenerateCredentialParameters the parameters used to regenerate the login credential.
type RegenerateCredentialParameters struct {
	// Name - Specifies name of the password which should be regenerated -- password or password2. Possible values include: 'Password', 'Password2'
	Name PasswordName `json:"name,omitempty"`
}

// RegistriesCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (Registry, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesCreateFuture.Result.
func (future *RegistriesCreateFuture) result(client RegistriesClient) (r Registry, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		r.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.CreateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RegistriesCreateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// RegistriesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesDeleteFuture.Result.
func (future *RegistriesDeleteFuture) result(client RegistriesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// RegistriesUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type RegistriesUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(RegistriesClient) (Registry, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *RegistriesUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for RegistriesUpdateFuture.Result.
func (future *RegistriesUpdateFuture) result(client RegistriesClient) (r Registry, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.RegistriesUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		r.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.RegistriesUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.UpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.RegistriesUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// Registry an object that represents a container registry.
type Registry struct {
	autorest.Response `json:"-"`
	// Sku - The SKU of the container registry.
	Sku *Sku `json:"sku,omitempty"`
	// RegistryProperties - The properties of the container registry.
	*RegistryProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Registry.
func (r Registry) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Sku != nil {
		objectMap["sku"] = r.Sku
	}
	if r.RegistryProperties != nil {
		objectMap["properties"] = r.RegistryProperties
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Registry struct.
func (r *Registry) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				r.Sku = &sku
			}
		case "properties":
			if v != nil {
				var registryProperties RegistryProperties
				err = json.Unmarshal(*v, &registryProperties)
				if err != nil {
					return err
				}
				r.RegistryProperties = &registryProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				r.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				r.Tags = tags
			}
		}
	}

	return nil
}

// RegistryListCredentialsResult the response from the ListCredentials operation.
type RegistryListCredentialsResult struct {
	autorest.Response `json:"-"`
	// Username - The username for a container registry.
	Username *string `json:"username,omitempty"`
	// Passwords - The list of passwords for a container registry.
	Passwords *[]RegistryPassword `json:"passwords,omitempty"`
}

// RegistryListResult the result of a request to list container registries.
type RegistryListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container registries. Since this list may be incomplete, the nextLink field should be used to request the next list of container registries.
	Value *[]Registry `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of container registries.
	NextLink *string `json:"nextLink,omitempty"`
}

// RegistryListResultIterator provides access to a complete listing of Registry values.
type RegistryListResultIterator struct {
	i    int
	page RegistryListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *RegistryListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegistryListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *RegistryListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter RegistryListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter RegistryListResultIterator) Response() RegistryListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter RegistryListResultIterator) Value() Registry {
	if !iter.page.NotDone() {
		return Registry{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the RegistryListResultIterator type.
func NewRegistryListResultIterator(page RegistryListResultPage) RegistryListResultIterator {
	return RegistryListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr RegistryListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr RegistryListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// registryListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr RegistryListResult) registryListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// RegistryListResultPage contains a page of Registry values.
type RegistryListResultPage struct {
	fn  func(context.Context, RegistryListResult) (RegistryListResult, error)
	rlr RegistryListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *RegistryListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RegistryListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *RegistryListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page RegistryListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page RegistryListResultPage) Response() RegistryListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page RegistryListResultPage) Values() []Registry {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the RegistryListResultPage type.
func NewRegistryListResultPage(cur RegistryListResult, getNextPage func(context.Context, RegistryListResult) (RegistryListResult, error)) RegistryListResultPage {
	return RegistryListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// RegistryNameCheckRequest a request to check whether a container registry name is available.
type RegistryNameCheckRequest struct {
	// Name - The name of the container registry.
	Name *string `json:"name,omitempty"`
	// Type - The resource type of the container registry. This field must be set to 'Microsoft.ContainerRegistry/registries'.
	Type *string `json:"type,omitempty"`
}

// RegistryNameStatus the result of a request to check the availability of a container registry name.
type RegistryNameStatus struct {
	autorest.Response `json:"-"`
	// NameAvailable - The value that indicates whether the name is available.
	NameAvailable *bool `json:"nameAvailable,omitempty"`
	// Reason - If any, the reason that the name is not available.
	Reason *string `json:"reason,omitempty"`
	// Message - If any, the error message that provides more detail for the reason that the name is not available.
	Message *string `json:"message,omitempty"`
}

// RegistryPassword the login password for the container registry.
type RegistryPassword struct {
	// Name - The password name. Possible values include: 'Password', 'Password2'
	Name PasswordName `json:"name,omitempty"`
	// Value - The password value.
	Value *string `json:"value,omitempty"`
}

// RegistryProperties the properties of a container registry.
type RegistryProperties struct {
	// LoginServer - READ-ONLY; The URL that can be used to log into the container registry.
	LoginServer *string `json:"loginServer,omitempty"`
	// CreationDate - READ-ONLY; The creation date of the container registry in ISO8601 format.
	CreationDate *date.Time `json:"creationDate,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the container registry at the time the operation was called. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; The status of the container registry at the time the operation was called.
	Status *Status `json:"status,omitempty"`
	// AdminUserEnabled - The value that indicates whether the admin user is enabled.
	AdminUserEnabled *bool `json:"adminUserEnabled,omitempty"`
	// StorageAccount - The properties of the storage account for the container registry. Only applicable to Basic SKU.
	StorageAccount *StorageAccountProperties `json:"storageAccount,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryProperties.
func (rp RegistryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rp.AdminUserEnabled != nil {
		objectMap["adminUserEnabled"] = rp.AdminUserEnabled
	}
	if rp.StorageAccount != nil {
		objectMap["storageAccount"] = rp.StorageAccount
	}
	return json.Marshal(objectMap)
}

// RegistryPropertiesUpdateParameters the parameters for updating the properties of a container registry.
type RegistryPropertiesUpdateParameters struct {
	// AdminUserEnabled - The value that indicates whether the admin user is enabled.
	AdminUserEnabled *bool `json:"adminUserEnabled,omitempty"`
	// StorageAccount - The parameters of a storage account for the container registry. Only applicable to Basic SKU. If specified, the storage account must be in the same physical location as the container registry.
	StorageAccount *StorageAccountProperties `json:"storageAccount,omitempty"`
}

// RegistryUpdateParameters the parameters for updating a container registry.
type RegistryUpdateParameters struct {
	// Tags - The tags for the container registry.
	Tags map[string]*string `json:"tags"`
	// Sku - The SKU of the container registry.
	Sku *Sku `json:"sku,omitempty"`
	// RegistryPropertiesUpdateParameters - The properties that the container registry will be updated with.
	*RegistryPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for RegistryUpdateParameters.
func (rup RegistryUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rup.Tags != nil {
		objectMap["tags"] = rup.Tags
	}
	if rup.Sku != nil {
		objectMap["sku"] = rup.Sku
	}
	if rup.RegistryPropertiesUpdateParameters != nil {
		objectMap["properties"] = rup.RegistryPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RegistryUpdateParameters struct.
func (rup *RegistryUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rup.Tags = tags
			}
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				rup.Sku = &sku
			}
		case "properties":
			if v != nil {
				var registryPropertiesUpdateParameters RegistryPropertiesUpdateParameters
				err = json.Unmarshal(*v, &registryPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				rup.RegistryPropertiesUpdateParameters = &registryPropertiesUpdateParameters
			}
		}
	}

	return nil
}

// RegistryUsage the quota usage for a container registry.
type RegistryUsage struct {
	// Name - The name of the usage.
	Name *string `json:"name,omitempty"`
	// Limit - The limit of the usage.
	Limit *int64 `json:"limit,omitempty"`
	// CurrentValue - The current value of the usage.
	CurrentValue *int64 `json:"currentValue,omitempty"`
	// Unit - The unit of measurement. Possible values include: 'Count', 'Bytes'
	Unit RegistryUsageUnit `json:"unit,omitempty"`
}

// RegistryUsageListResult the result of a request to get container registry quota usages.
type RegistryUsageListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of container registry quota usages.
	Value *[]RegistryUsage `json:"value,omitempty"`
}

// Replication an object that represents a replication for a container registry.
type Replication struct {
	autorest.Response `json:"-"`
	// ReplicationProperties - The properties of the replication.
	*ReplicationProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Replication.
func (r Replication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ReplicationProperties != nil {
		objectMap["properties"] = r.ReplicationProperties
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Replication struct.
func (r *Replication) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var replicationProperties ReplicationProperties
				err = json.Unmarshal(*v, &replicationProperties)
				if err != nil {
					return err
				}
				r.ReplicationProperties = &replicationProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				r.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				r.Tags = tags
			}
		}
	}

	return nil
}

// ReplicationListResult the result of a request to list replications for a container registry.
type ReplicationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of replications. Since this list may be incomplete, the nextLink field should be used to request the next list of replications.
	Value *[]Replication `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of replications.
	NextLink *string `json:"nextLink,omitempty"`
}

// ReplicationListResultIterator provides access to a complete listing of Replication values.
type ReplicationListResultIterator struct {
	i    int
	page ReplicationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ReplicationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ReplicationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ReplicationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ReplicationListResultIterator) Response() ReplicationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ReplicationListResultIterator) Value() Replication {
	if !iter.page.NotDone() {
		return Replication{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ReplicationListResultIterator type.
func NewReplicationListResultIterator(page ReplicationListResultPage) ReplicationListResultIterator {
	return ReplicationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (rlr ReplicationListResult) IsEmpty() bool {
	return rlr.Value == nil || len(*rlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (rlr ReplicationListResult) hasNextLink() bool {
	return rlr.NextLink != nil && len(*rlr.NextLink) != 0
}

// replicationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (rlr ReplicationListResult) replicationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !rlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(rlr.NextLink)))
}

// ReplicationListResultPage contains a page of Replication values.
type ReplicationListResultPage struct {
	fn  func(context.Context, ReplicationListResult) (ReplicationListResult, error)
	rlr ReplicationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ReplicationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ReplicationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.rlr)
		if err != nil {
			return err
		}
		page.rlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ReplicationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ReplicationListResultPage) NotDone() bool {
	return !page.rlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ReplicationListResultPage) Response() ReplicationListResult {
	return page.rlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ReplicationListResultPage) Values() []Replication {
	if page.rlr.IsEmpty() {
		return nil
	}
	return *page.rlr.Value
}

// Creates a new instance of the ReplicationListResultPage type.
func NewReplicationListResultPage(cur ReplicationListResult, getNextPage func(context.Context, ReplicationListResult) (ReplicationListResult, error)) ReplicationListResultPage {
	return ReplicationListResultPage{
		fn:  getNextPage,
		rlr: cur,
	}
}

// ReplicationProperties the properties of a replication.
type ReplicationProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state of the replication at the time the operation was called. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Status - READ-ONLY; The status of the replication at the time the operation was called.
	Status *Status `json:"status,omitempty"`
}

// MarshalJSON is the custom marshaler for ReplicationProperties.
func (rp ReplicationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ReplicationsCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationsCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationsClient) (Replication, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationsCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationsCreateFuture.Result.
func (future *ReplicationsCreateFuture) result(client ReplicationsClient) (r Replication, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		r.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.ReplicationsCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.CreateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsCreateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationsDeleteFuture.Result.
func (future *ReplicationsDeleteFuture) result(client ReplicationsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.ReplicationsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// ReplicationsUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ReplicationsUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(ReplicationsClient) (Replication, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ReplicationsUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ReplicationsUpdateFuture.Result.
func (future *ReplicationsUpdateFuture) result(client ReplicationsClient) (r Replication, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		r.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.ReplicationsUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if r.Response.Response, err = future.GetResult(sender); err == nil && r.Response.Response.StatusCode != http.StatusNoContent {
		r, err = client.UpdateResponder(r.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.ReplicationsUpdateFuture", "Result", r.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ReplicationUpdateParameters the parameters for updating a replication.
type ReplicationUpdateParameters struct {
	// Tags - The tags for the replication.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ReplicationUpdateParameters.
func (rup ReplicationUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rup.Tags != nil {
		objectMap["tags"] = rup.Tags
	}
	return json.Marshal(objectMap)
}

// Request the request that generated the event.
type Request struct {
	// ID - The ID of the request that initiated the event.
	ID *string `json:"id,omitempty"`
	// Addr - The IP or hostname and possibly port of the client connection that initiated the event. This is the RemoteAddr from the standard http request.
	Addr *string `json:"addr,omitempty"`
	// Host - The externally accessible hostname of the registry instance, as specified by the http host header on incoming requests.
	Host *string `json:"host,omitempty"`
	// Method - The request method that generated the event.
	Method *string `json:"method,omitempty"`
	// Useragent - The user agent header of the request.
	Useragent *string `json:"useragent,omitempty"`
}

// Resource an Azure resource.
type Resource struct {
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// Sku the SKU of a container registry.
type Sku struct {
	// Name - The SKU name of the container registry. Required for registry creation. Possible values include: 'Basic', 'ManagedBasic', 'ManagedStandard', 'ManagedPremium'
	Name SkuName `json:"name,omitempty"`
	// Tier - READ-ONLY; The SKU tier based on the SKU name. Possible values include: 'SkuTierBasic', 'SkuTierManaged'
	Tier SkuTier `json:"tier,omitempty"`
}

// MarshalJSON is the custom marshaler for Sku.
func (s Sku) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.Name != "" {
		objectMap["name"] = s.Name
	}
	return json.Marshal(objectMap)
}

// Source the registry node that generated the event. Put differently, while the actor initiates the event,
// the source generates it.
type Source struct {
	// Addr - The IP or hostname and the port of the registry node that generated the event. Generally, this will be resolved by os.Hostname() along with the running port.
	Addr *string `json:"addr,omitempty"`
	// InstanceID - The running instance of an application. Changes after each restart.
	InstanceID *string `json:"instanceID,omitempty"`
}

// Status the status of an Azure resource at the time the operation was called.
type Status struct {
	// DisplayStatus - READ-ONLY; The short label for the status.
	DisplayStatus *string `json:"displayStatus,omitempty"`
	// Message - READ-ONLY; The detailed message for the status, including alerts and error messages.
	Message *string `json:"message,omitempty"`
	// Timestamp - READ-ONLY; The timestamp when the status was changed to the current value.
	Timestamp *date.Time `json:"timestamp,omitempty"`
}

// MarshalJSON is the custom marshaler for Status.
func (s Status) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// StorageAccountProperties the properties of a storage account for a container registry. Only applicable
// to Basic SKU.
type StorageAccountProperties struct {
	// ID - The resource ID of the storage account.
	ID *string `json:"id,omitempty"`
}

// Target the target of the event.
type Target struct {
	// MediaType - The MIME type of the referenced object.
	MediaType *string `json:"mediaType,omitempty"`
	// Size - The number of bytes of the content. Same as Length field.
	Size *int64 `json:"size,omitempty"`
	// Digest - The digest of the content, as defined by the Registry V2 HTTP API Specification.
	Digest *string `json:"digest,omitempty"`
	// Length - The number of bytes of the content. Same as Size field.
	Length *int64 `json:"length,omitempty"`
	// Repository - The repository name.
	Repository *string `json:"repository,omitempty"`
	// URL - The direct URL to the content.
	URL *string `json:"url,omitempty"`
	// Tag - The tag name.
	Tag *string `json:"tag,omitempty"`
}

// Webhook an object that represents a webhook for a container registry.
type Webhook struct {
	autorest.Response `json:"-"`
	// WebhookProperties - The properties of the webhook.
	*WebhookProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; The resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
	// Location - The location of the resource. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// Tags - The tags of the resource.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Webhook.
func (w Webhook) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WebhookProperties != nil {
		objectMap["properties"] = w.WebhookProperties
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Webhook struct.
func (w *Webhook) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var webhookProperties WebhookProperties
				err = json.Unmarshal(*v, &webhookProperties)
				if err != nil {
					return err
				}
				w.WebhookProperties = &webhookProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		}
	}

	return nil
}

// WebhookCreateParameters the parameters for creating a webhook.
type WebhookCreateParameters struct {
	// Tags - The tags for the webhook.
	Tags map[string]*string `json:"tags"`
	// Location - The location of the webhook. This cannot be changed after the resource is created.
	Location *string `json:"location,omitempty"`
	// WebhookPropertiesCreateParameters - The properties that the webhook will be created with.
	*WebhookPropertiesCreateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookCreateParameters.
func (wcp WebhookCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wcp.Tags != nil {
		objectMap["tags"] = wcp.Tags
	}
	if wcp.Location != nil {
		objectMap["location"] = wcp.Location
	}
	if wcp.WebhookPropertiesCreateParameters != nil {
		objectMap["properties"] = wcp.WebhookPropertiesCreateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebhookCreateParameters struct.
func (wcp *WebhookCreateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wcp.Tags = tags
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wcp.Location = &location
			}
		case "properties":
			if v != nil {
				var webhookPropertiesCreateParameters WebhookPropertiesCreateParameters
				err = json.Unmarshal(*v, &webhookPropertiesCreateParameters)
				if err != nil {
					return err
				}
				wcp.WebhookPropertiesCreateParameters = &webhookPropertiesCreateParameters
			}
		}
	}

	return nil
}

// WebhookListResult the result of a request to list webhooks for a container registry.
type WebhookListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of webhooks. Since this list may be incomplete, the nextLink field should be used to request the next list of webhooks.
	Value *[]Webhook `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of webhooks.
	NextLink *string `json:"nextLink,omitempty"`
}

// WebhookListResultIterator provides access to a complete listing of Webhook values.
type WebhookListResultIterator struct {
	i    int
	page WebhookListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WebhookListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebhookListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WebhookListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WebhookListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WebhookListResultIterator) Response() WebhookListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WebhookListResultIterator) Value() Webhook {
	if !iter.page.NotDone() {
		return Webhook{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WebhookListResultIterator type.
func NewWebhookListResultIterator(page WebhookListResultPage) WebhookListResultIterator {
	return WebhookListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WebhookListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wlr WebhookListResult) hasNextLink() bool {
	return wlr.NextLink != nil && len(*wlr.NextLink) != 0
}

// webhookListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WebhookListResult) webhookListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !wlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WebhookListResultPage contains a page of Webhook values.
type WebhookListResultPage struct {
	fn  func(context.Context, WebhookListResult) (WebhookListResult, error)
	wlr WebhookListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WebhookListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WebhookListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wlr)
		if err != nil {
			return err
		}
		page.wlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WebhookListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WebhookListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WebhookListResultPage) Response() WebhookListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WebhookListResultPage) Values() []Webhook {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// Creates a new instance of the WebhookListResultPage type.
func NewWebhookListResultPage(cur WebhookListResult, getNextPage func(context.Context, WebhookListResult) (WebhookListResult, error)) WebhookListResultPage {
	return WebhookListResultPage{
		fn:  getNextPage,
		wlr: cur,
	}
}

// WebhookProperties the properties of a webhook.
type WebhookProperties struct {
	// Status - The status of the webhook at the time the operation was called. Possible values include: 'Enabled', 'Disabled'
	Status WebhookStatus `json:"status,omitempty"`
	// Scope - The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`
	// Actions - The list of actions that trigger the webhook to post notifications.
	Actions *[]WebhookAction `json:"actions,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the webhook at the time the operation was called. Possible values include: 'Creating', 'Updating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookProperties.
func (wp WebhookProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wp.Status != "" {
		objectMap["status"] = wp.Status
	}
	if wp.Scope != nil {
		objectMap["scope"] = wp.Scope
	}
	if wp.Actions != nil {
		objectMap["actions"] = wp.Actions
	}
	return json.Marshal(objectMap)
}

// WebhookPropertiesCreateParameters the parameters for creating the properties of a webhook.
type WebhookPropertiesCreateParameters struct {
	// ServiceURI - The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// CustomHeaders - Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders"`
	// Status - The status of the webhook at the time the operation was called. Possible values include: 'Enabled', 'Disabled'
	Status WebhookStatus `json:"status,omitempty"`
	// Scope - The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`
	// Actions - The list of actions that trigger the webhook to post notifications.
	Actions *[]WebhookAction `json:"actions,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookPropertiesCreateParameters.
func (wpcp WebhookPropertiesCreateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpcp.ServiceURI != nil {
		objectMap["serviceUri"] = wpcp.ServiceURI
	}
	if wpcp.CustomHeaders != nil {
		objectMap["customHeaders"] = wpcp.CustomHeaders
	}
	if wpcp.Status != "" {
		objectMap["status"] = wpcp.Status
	}
	if wpcp.Scope != nil {
		objectMap["scope"] = wpcp.Scope
	}
	if wpcp.Actions != nil {
		objectMap["actions"] = wpcp.Actions
	}
	return json.Marshal(objectMap)
}

// WebhookPropertiesUpdateParameters the parameters for updating the properties of a webhook.
type WebhookPropertiesUpdateParameters struct {
	// ServiceURI - The service URI for the webhook to post notifications.
	ServiceURI *string `json:"serviceUri,omitempty"`
	// CustomHeaders - Custom headers that will be added to the webhook notifications.
	CustomHeaders map[string]*string `json:"customHeaders"`
	// Status - The status of the webhook at the time the operation was called. Possible values include: 'Enabled', 'Disabled'
	Status WebhookStatus `json:"status,omitempty"`
	// Scope - The scope of repositories where the event can be triggered. For example, 'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
	Scope *string `json:"scope,omitempty"`
	// Actions - The list of actions that trigger the webhook to post notifications.
	Actions *[]WebhookAction `json:"actions,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookPropertiesUpdateParameters.
func (wpup WebhookPropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wpup.ServiceURI != nil {
		objectMap["serviceUri"] = wpup.ServiceURI
	}
	if wpup.CustomHeaders != nil {
		objectMap["customHeaders"] = wpup.CustomHeaders
	}
	if wpup.Status != "" {
		objectMap["status"] = wpup.Status
	}
	if wpup.Scope != nil {
		objectMap["scope"] = wpup.Scope
	}
	if wpup.Actions != nil {
		objectMap["actions"] = wpup.Actions
	}
	return json.Marshal(objectMap)
}

// WebhooksCreateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WebhooksCreateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WebhooksClient) (Webhook, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WebhooksCreateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WebhooksCreateFuture.Result.
func (future *WebhooksCreateFuture) result(client WebhooksClient) (w Webhook, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.WebhooksCreateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		w.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.WebhooksCreateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.CreateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.WebhooksCreateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WebhooksDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WebhooksDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WebhooksClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WebhooksDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WebhooksDeleteFuture.Result.
func (future *WebhooksDeleteFuture) result(client WebhooksClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.WebhooksDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.WebhooksDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WebhooksUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WebhooksUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(WebhooksClient) (Webhook, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *WebhooksUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for WebhooksUpdateFuture.Result.
func (future *WebhooksUpdateFuture) result(client WebhooksClient) (w Webhook, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "containerregistry.WebhooksUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		w.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("containerregistry.WebhooksUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if w.Response.Response, err = future.GetResult(sender); err == nil && w.Response.Response.StatusCode != http.StatusNoContent {
		w, err = client.UpdateResponder(w.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "containerregistry.WebhooksUpdateFuture", "Result", w.Response.Response, "Failure responding to request")
		}
	}
	return
}

// WebhookUpdateParameters the parameters for updating a webhook.
type WebhookUpdateParameters struct {
	// Tags - The tags for the webhook.
	Tags map[string]*string `json:"tags"`
	// WebhookPropertiesUpdateParameters - The properties that the webhook will be updated with.
	*WebhookPropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WebhookUpdateParameters.
func (wup WebhookUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wup.Tags != nil {
		objectMap["tags"] = wup.Tags
	}
	if wup.WebhookPropertiesUpdateParameters != nil {
		objectMap["properties"] = wup.WebhookPropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WebhookUpdateParameters struct.
func (wup *WebhookUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wup.Tags = tags
			}
		case "properties":
			if v != nil {
				var webhookPropertiesUpdateParameters WebhookPropertiesUpdateParameters
				err = json.Unmarshal(*v, &webhookPropertiesUpdateParameters)
				if err != nil {
					return err
				}
				wup.WebhookPropertiesUpdateParameters = &webhookPropertiesUpdateParameters
			}
		}
	}

	return nil
}
