package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLogQuery invokes the aegis.DeleteLogQuery API synchronously
// api document: https://help.aliyun.com/api/aegis/deletelogquery.html
func (client *Client) DeleteLogQuery(request *DeleteLogQueryRequest) (response *DeleteLogQueryResponse, err error) {
	response = CreateDeleteLogQueryResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLogQueryWithChan invokes the aegis.DeleteLogQuery API asynchronously
// api document: https://help.aliyun.com/api/aegis/deletelogquery.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLogQueryWithChan(request *DeleteLogQueryRequest) (<-chan *DeleteLogQueryResponse, <-chan error) {
	responseChan := make(chan *DeleteLogQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLogQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLogQueryWithCallback invokes the aegis.DeleteLogQuery API asynchronously
// api document: https://help.aliyun.com/api/aegis/deletelogquery.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteLogQueryWithCallback(request *DeleteLogQueryRequest, callback func(response *DeleteLogQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLogQueryResponse
		var err error
		defer close(result)
		response, err = client.DeleteLogQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLogQueryRequest is the request struct for api DeleteLogQuery
type DeleteLogQueryRequest struct {
	*requests.RpcRequest
	SourceIp  string `position:"Query" name:"SourceIp"`
	QueryName string `position:"Query" name:"QueryName"`
}

// DeleteLogQueryResponse is the response struct for api DeleteLogQuery
type DeleteLogQueryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLogQueryRequest creates a request to invoke DeleteLogQuery API
func CreateDeleteLogQueryRequest() (request *DeleteLogQueryRequest) {
	request = &DeleteLogQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DeleteLogQuery", "vipaegis", "openAPI")
	return
}

// CreateDeleteLogQueryResponse creates a response to parse from DeleteLogQuery response
func CreateDeleteLogQueryResponse() (response *DeleteLogQueryResponse) {
	response = &DeleteLogQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
