package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExperiments invokes the airec.ListExperiments API synchronously
func (client *Client) ListExperiments(request *ListExperimentsRequest) (response *ListExperimentsResponse, err error) {
	response = CreateListExperimentsResponse()
	err = client.DoAction(request, response)
	return
}

// ListExperimentsWithChan invokes the airec.ListExperiments API asynchronously
func (client *Client) ListExperimentsWithChan(request *ListExperimentsRequest) (<-chan *ListExperimentsResponse, <-chan error) {
	responseChan := make(chan *ListExperimentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExperiments(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExperimentsWithCallback invokes the airec.ListExperiments API asynchronously
func (client *Client) ListExperimentsWithCallback(request *ListExperimentsRequest, callback func(response *ListExperimentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExperimentsResponse
		var err error
		defer close(result)
		response, err = client.ListExperiments(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExperimentsRequest is the request struct for api ListExperiments
type ListExperimentsRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"instanceId"`
	SceneId    string `position:"Path" name:"sceneId"`
}

// ListExperimentsResponse is the response struct for api ListExperiments
type ListExperimentsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"requestId" xml:"requestId"`
	Result    []ResultItem `json:"result" xml:"result"`
}

// CreateListExperimentsRequest creates a request to invoke ListExperiments API
func CreateListExperimentsRequest() (request *ListExperimentsRequest) {
	request = &ListExperimentsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "ListExperiments", "/v2/openapi/instances/[instanceId]/scenes/[sceneId]/experiments", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListExperimentsResponse creates a response to parse from ListExperiments response
func CreateListExperimentsResponse() (response *ListExperimentsResponse) {
	response = &ListExperimentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
