package appmallsservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TaobaoFilmGetRegionList invokes the appmallsservice.TaobaoFilmGetRegionList API synchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgetregionlist.html
func (client *Client) TaobaoFilmGetRegionList(request *TaobaoFilmGetRegionListRequest) (response *TaobaoFilmGetRegionListResponse, err error) {
	response = CreateTaobaoFilmGetRegionListResponse()
	err = client.DoAction(request, response)
	return
}

// TaobaoFilmGetRegionListWithChan invokes the appmallsservice.TaobaoFilmGetRegionList API asynchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgetregionlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TaobaoFilmGetRegionListWithChan(request *TaobaoFilmGetRegionListRequest) (<-chan *TaobaoFilmGetRegionListResponse, <-chan error) {
	responseChan := make(chan *TaobaoFilmGetRegionListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TaobaoFilmGetRegionList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TaobaoFilmGetRegionListWithCallback invokes the appmallsservice.TaobaoFilmGetRegionList API asynchronously
// api document: https://help.aliyun.com/api/appmallsservice/taobaofilmgetregionlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) TaobaoFilmGetRegionListWithCallback(request *TaobaoFilmGetRegionListRequest, callback func(response *TaobaoFilmGetRegionListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TaobaoFilmGetRegionListResponse
		var err error
		defer close(result)
		response, err = client.TaobaoFilmGetRegionList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TaobaoFilmGetRegionListRequest is the request struct for api TaobaoFilmGetRegionList
type TaobaoFilmGetRegionListRequest struct {
	*requests.RpcRequest
	ParamsJson string `position:"Query" name:"ParamsJson"`
}

// TaobaoFilmGetRegionListResponse is the response struct for api TaobaoFilmGetRegionList
type TaobaoFilmGetRegionListResponse struct {
	*responses.BaseResponse
	ErrorCode string        `json:"ErrorCode" xml:"ErrorCode"`
	Msg       string        `json:"Msg" xml:"Msg"`
	SubCode   string        `json:"SubCode" xml:"SubCode"`
	SubMsg    string        `json:"SubMsg" xml:"SubMsg"`
	LogsId    string        `json:"LogsId" xml:"LogsId"`
	RequestId string        `json:"RequestId" xml:"RequestId"`
	Regions   []RegionsItem `json:"Regions" xml:"Regions"`
}

// CreateTaobaoFilmGetRegionListRequest creates a request to invoke TaobaoFilmGetRegionList API
func CreateTaobaoFilmGetRegionListRequest() (request *TaobaoFilmGetRegionListRequest) {
	request = &TaobaoFilmGetRegionListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("AppMallsService", "2018-02-24", "TaobaoFilmGetRegionList", "", "")
	return
}

// CreateTaobaoFilmGetRegionListResponse creates a response to parse from TaobaoFilmGetRegionList response
func CreateTaobaoFilmGetRegionListResponse() (response *TaobaoFilmGetRegionListResponse) {
	response = &TaobaoFilmGetRegionListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
