package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListClusterFromGrafana invokes the arms.ListClusterFromGrafana API synchronously
func (client *Client) ListClusterFromGrafana(request *ListClusterFromGrafanaRequest) (response *ListClusterFromGrafanaResponse, err error) {
	response = CreateListClusterFromGrafanaResponse()
	err = client.DoAction(request, response)
	return
}

// ListClusterFromGrafanaWithChan invokes the arms.ListClusterFromGrafana API asynchronously
func (client *Client) ListClusterFromGrafanaWithChan(request *ListClusterFromGrafanaRequest) (<-chan *ListClusterFromGrafanaResponse, <-chan error) {
	responseChan := make(chan *ListClusterFromGrafanaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListClusterFromGrafana(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListClusterFromGrafanaWithCallback invokes the arms.ListClusterFromGrafana API asynchronously
func (client *Client) ListClusterFromGrafanaWithCallback(request *ListClusterFromGrafanaRequest, callback func(response *ListClusterFromGrafanaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListClusterFromGrafanaResponse
		var err error
		defer close(result)
		response, err = client.ListClusterFromGrafana(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListClusterFromGrafanaRequest is the request struct for api ListClusterFromGrafana
type ListClusterFromGrafanaRequest struct {
	*requests.RpcRequest
}

// ListClusterFromGrafanaResponse is the response struct for api ListClusterFromGrafana
type ListClusterFromGrafanaResponse struct {
	*responses.BaseResponse
	RequestId       string        `json:"RequestId" xml:"RequestId"`
	PromClusterList []PromCluster `json:"PromClusterList" xml:"PromClusterList"`
}

// CreateListClusterFromGrafanaRequest creates a request to invoke ListClusterFromGrafana API
func CreateListClusterFromGrafanaRequest() (request *ListClusterFromGrafanaRequest) {
	request = &ListClusterFromGrafanaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ListClusterFromGrafana", "", "")
	request.Method = requests.POST
	return
}

// CreateListClusterFromGrafanaResponse creates a response to parse from ListClusterFromGrafana response
func CreateListClusterFromGrafanaResponse() (response *ListClusterFromGrafanaResponse) {
	response = &ListClusterFromGrafanaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
