package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAntChainContractContent invokes the baas.DeleteAntChainContractContent API synchronously
// api document: https://help.aliyun.com/api/baas/deleteantchaincontractcontent.html
func (client *Client) DeleteAntChainContractContent(request *DeleteAntChainContractContentRequest) (response *DeleteAntChainContractContentResponse, err error) {
	response = CreateDeleteAntChainContractContentResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAntChainContractContentWithChan invokes the baas.DeleteAntChainContractContent API asynchronously
// api document: https://help.aliyun.com/api/baas/deleteantchaincontractcontent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAntChainContractContentWithChan(request *DeleteAntChainContractContentRequest) (<-chan *DeleteAntChainContractContentResponse, <-chan error) {
	responseChan := make(chan *DeleteAntChainContractContentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAntChainContractContent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAntChainContractContentWithCallback invokes the baas.DeleteAntChainContractContent API asynchronously
// api document: https://help.aliyun.com/api/baas/deleteantchaincontractcontent.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAntChainContractContentWithCallback(request *DeleteAntChainContractContentRequest, callback func(response *DeleteAntChainContractContentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAntChainContractContentResponse
		var err error
		defer close(result)
		response, err = client.DeleteAntChainContractContent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAntChainContractContentRequest is the request struct for api DeleteAntChainContractContent
type DeleteAntChainContractContentRequest struct {
	*requests.RpcRequest
	ContentId string `position:"Body" name:"ContentId"`
}

// DeleteAntChainContractContentResponse is the response struct for api DeleteAntChainContractContent
type DeleteAntChainContractContentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateDeleteAntChainContractContentRequest creates a request to invoke DeleteAntChainContractContent API
func CreateDeleteAntChainContractContentRequest() (request *DeleteAntChainContractContentRequest) {
	request = &DeleteAntChainContractContentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DeleteAntChainContractContent", "baas", "openAPI")
	return
}

// CreateDeleteAntChainContractContentResponse creates a response to parse from DeleteAntChainContractContent response
func CreateDeleteAntChainContractContentResponse() (response *DeleteAntChainContractContentResponse) {
	response = &DeleteAntChainContractContentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
