package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSSLCertificatePrivateKey invokes the cas.DescribeSSLCertificatePrivateKey API synchronously
func (client *Client) DescribeSSLCertificatePrivateKey(request *DescribeSSLCertificatePrivateKeyRequest) (response *DescribeSSLCertificatePrivateKeyResponse, err error) {
	response = CreateDescribeSSLCertificatePrivateKeyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSSLCertificatePrivateKeyWithChan invokes the cas.DescribeSSLCertificatePrivateKey API asynchronously
func (client *Client) DescribeSSLCertificatePrivateKeyWithChan(request *DescribeSSLCertificatePrivateKeyRequest) (<-chan *DescribeSSLCertificatePrivateKeyResponse, <-chan error) {
	responseChan := make(chan *DescribeSSLCertificatePrivateKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSSLCertificatePrivateKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSSLCertificatePrivateKeyWithCallback invokes the cas.DescribeSSLCertificatePrivateKey API asynchronously
func (client *Client) DescribeSSLCertificatePrivateKeyWithCallback(request *DescribeSSLCertificatePrivateKeyRequest, callback func(response *DescribeSSLCertificatePrivateKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSSLCertificatePrivateKeyResponse
		var err error
		defer close(result)
		response, err = client.DescribeSSLCertificatePrivateKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSSLCertificatePrivateKeyRequest is the request struct for api DescribeSSLCertificatePrivateKey
type DescribeSSLCertificatePrivateKeyRequest struct {
	*requests.RpcRequest
	SourceIp       string `position:"Query" name:"SourceIp"`
	EncryptedCode  string `position:"Query" name:"EncryptedCode"`
	CertIdentifier string `position:"Query" name:"CertIdentifier"`
}

// DescribeSSLCertificatePrivateKeyResponse is the response struct for api DescribeSSLCertificatePrivateKey
type DescribeSSLCertificatePrivateKeyResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	X509PrivateKey string `json:"X509PrivateKey" xml:"X509PrivateKey"`
}

// CreateDescribeSSLCertificatePrivateKeyRequest creates a request to invoke DescribeSSLCertificatePrivateKey API
func CreateDescribeSSLCertificatePrivateKeyRequest() (request *DescribeSSLCertificatePrivateKeyRequest) {
	request = &DescribeSSLCertificatePrivateKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-06-19", "DescribeSSLCertificatePrivateKey", "cas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSSLCertificatePrivateKeyResponse creates a response to parse from DescribeSSLCertificatePrivateKey response
func CreateDescribeSSLCertificatePrivateKeyResponse() (response *DescribeSSLCertificatePrivateKeyResponse) {
	response = &DescribeSSLCertificatePrivateKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
